/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Date;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.mediator.Mediator;
import uk.ac.imperial.doc.kenya.styleCheckers.ICheckedCode;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaHelperThread implements Runnable {

    private final EditingWindow window;

    public KenyaHelperThread(EditingWindow w) {
        window = w;
    }

    private final long sleepPeriod = 500;

    public void run() {

        try {
            while (!window.isVisible()) {
                try {
                    Thread.sleep(sleepPeriod);
                } catch (InterruptedException e) {
                }
            }

            if (EditingWindowUtilsFactory.kenya.isExiting()) return;

            final StyledText text = window.getKenyaTextWidget();
            Runnable reparseComments = new Runnable() {

                public void run() {
                    window.getKenyaLineStyler().parseBlockComments(
                            text.getContent());
                    window.getTopTabs().redraw();
                }
            };

            String oldText = "";
            String lastParseText = "";
            int oldCaretOffset = -1;
            boolean redraw = false;
            while (!EditingWindowUtilsFactory.kenya.isExiting() && window.isVisible()) {
                String newText = window.getKenyaText();

                if (new Date().getTime() > window.getLastKeyEvent().getTime() + 1000) {
                    if (!lastParseText.equals(newText) || window.reparse()) {
                        try {
                            ICheckedCode checkedCode = Mediator
                                    .check(new StringReader(newText));
                            window.getHighlightingManager().clear();
                            window.setKenyaCheckedCode(checkedCode);
                            if (!checkedCode.isErroredCode()) {
                                window.setJavaCode(checkedCode.translate());
                            } else {
                                window.setJavaCode(null);
                            }
                        } catch (IOException e1) {
                            System.err.println("Error whilst parsing code.");
                        }
                        lastParseText = newText;
                        window.reparse(false);
                        redraw = true;
                    }
                    int offset = window.getKenyaCaretOffset();
                    if (oldCaretOffset != offset) {
                        window.getHighlightingManager().showLinkedHighlights(
                                offset);
                        oldCaretOffset = offset;
                        redraw = true;
                    }

                    if (redraw) {
                        window.safeRedraw();
                        redraw = false;
                    }
                }

                if (!oldText.equals(newText)) {
                    oldText = newText;
                    text.getDisplay().syncExec(reparseComments);
                }

                try {
                    Thread.sleep(sleepPeriod);
                } catch (InterruptedException e) {
                }
            }

        } catch (SWTException e) {
            if (EditingWindowUtilsFactory.kenya.isExiting()) {
            } else {
                throw e;
            }
        }
    }
}