/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;


import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;


/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaKeyListener implements VerifyKeyListener {
    
    private final EditingWindow window;
    
    public KenyaKeyListener(EditingWindow w) {
        window = w;
    }
    
    public void verifyKey(VerifyEvent event) {
        if (event.keyCode == SWT.TAB) {
            StyledText text = window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            window.getIndentationStrategy().tab(text, offset);
        } else if (event.keyCode == SWT.CR) {
            StyledText text = window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            window.getIndentationStrategy().insertCarriageReturn(text,
                    offset);
        } else if (event.character == '}') {
            StyledText text = window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            window.getIndentationStrategy().insertCloseBrace(text,
                    offset);
        } else if (event.character == '{') {
            StyledText text = window.getKenyaTextWidget();
            int offset = text.getCaretOffset();
            event.doit = false;
            window.getIndentationStrategy().insertOpenBrace(text,
                    offset);
        }
        window.resetTimer();
    }

}
