/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;


import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;


/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaTableSelectionChangedListener implements
        ISelectionChangedListener {
    
    private final EditingWindow window;
    
    public KenyaTableSelectionChangedListener(EditingWindow w) {
        window = w;
    }
    
    public void selectionChanged(SelectionChangedEvent event) {
        StyledText text = window.getKenyaTextWidget();
        IStructuredSelection selection = (IStructuredSelection) event
                .getSelection();
        if (selection.getFirstElement() != null) {
            ISourceCodeLocation location = ((ISourceCodeInformation) selection
                    .getFirstElement()).getLocation();
            if (location.getLineNumber() > 0) {
                int offset = text.getOffsetAtLine(location
                        .getLineNumber() - 1);
                offset += (location.getColumnNumber() - 1);
                text.setCaretOffset(offset);
                int length = location.getTokenLength();
                if (offset + length < text.getCharCount()) {
                        text.setSelectionRange(offset, length);
                        text.showSelection();
                }
                window.getHighlightingManager().showLinkedHighlights(
                        offset + 1);
            }
        }
        text.setFocus();
    }

}
