/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class StdOutWriter implements Runnable {
    
    private static final int MAXBUFFERSIZE = 64;

    private final BufferedReader reader;

    private final StyledText text;

    private static final int EOF = -1;

    private final StringBuffer line = new StringBuffer();

    private final int color;

    private final Runnable runner;

    public StdOutWriter(Reader r, StyledText t, int c) {
        reader = new BufferedReader(r);
        text = t;
        color = c;

        runner = new Runnable() {

            public void run() {
                String appendString = line.toString();
                if (appendString != null) {
                    text.append(appendString);
                    StyleRange sr = new StyleRange();
                    sr.start = text.getCharCount() - appendString.length();
                    sr.length = appendString.length();
                    sr.foreground = text.getDisplay().getSystemColor(color);
                    text.setStyleRange(sr);
                    text.setCaretOffset(text.getCharCount());
                    text.setSelection(text.getCharCount());
                    text.showSelection();
                }
            }
        };

    }

    public synchronized void run() {
        try {
            line.setLength(0);
            int c = reader.read();
            while (c != EOF) {
                line.append((char) c);

                if (!reader.ready() || line.length() >= MAXBUFFERSIZE) {
                    text.getDisplay().syncExec(runner);
                    line.setLength(0);
                }
                c = reader.read();
            }

        } catch (IOException e) {
            System.err.println("IO error when reading");
            e.printStackTrace();
        }
    }

}