/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 29, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils.interpreter;


import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class InterpreterStepModeButtonSelectionListener extends
        SelectionAdapter {

    private final EditingWindow window;
    
    private final Button button;

    public InterpreterStepModeButtonSelectionListener(EditingWindow w) {
        window = w;
        button = w.getInterpreterStepModeButton();
    }

    public void widgetSelected(SelectionEvent e) {
        IStackMachine sm = window.getStackMachine();
        boolean stepMode = button.getSelection();
        window.setInterpreterStepMode(stepMode);
        if (stepMode) {
            window.getInterpreterContinueButton().setText("Step");
            window.getInterpreterTrackButton().setEnabled(false);
            window.getInterpreterInterpretButton().setText("&Run Step by Step");
        } else {
            window.getInterpreterContinueButton().setText("Continue");
            window.getInterpreterTrackButton().setEnabled(true);
            window.getInterpreterInterpretButton().setText("&Run");
        }
        if (sm != null) sm.setStepMode(stepMode);
    }

}

