/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 29, 2004
 *
 */
package uk.ac.imperial.doc.kenya.gui.editor.utils.interpreter;

import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;

import uk.ac.imperial.doc.kenya.gui.editor.EditingWindow;
import uk.ac.imperial.doc.kenya.passes.IStackMachineInformationProvider;
import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedClass;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class InterpreterTerminateButtonSelectionListener extends
        SelectionAdapter {

    private final Button terminate;

    private final EditingWindow window;
    
    private final PrintWriter writer;
    
    private final ExecutorService executor;

    public InterpreterTerminateButtonSelectionListener(EditingWindow w, PrintWriter write) {
        window = w;
        terminate = w.getInterpreterTerminateButton();
        writer = write;
        executor = w.getExecutorService();
    }

    public void widgetSelected(SelectionEvent e) {
        terminate.setText("Terminating...");
        terminate.setEnabled(false);
        executor.execute(new Runnable() {

            public void run() {
                IStackMachineInformationProvider ismip = window
                        .getBaseStackMachine();
                IStackMachine sm = window.getStackMachine();
                String methodName = ismip.getEntryPoint();
                IInterpretedClass methodClass = ismip.getEntryPointClass();
                IAtomicClosure methodBody = methodClass.getMethod(methodName)
                        .getMethodBody();
                methodBody.getClosureScope().setReturn(true);
                writer.close();
                sm.shutdown();
                window.safeSetStatus("Debugger terminated.");
            }
        });
    }

}

