/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 10-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.mediator.stackMachine;

import java.util.HashMap;
import java.util.Map;

/**
 * Very very quick implementation of a BidirectionalMap
 * for use in StachMachineInformation.
 * 
 * There is 0 safety in here, don't think for a second its general purpose,
 * its not.
 * @author toa02
 *
 */
class BidirectionalMap<K, V> {
    
    private final Map<K, V> _AtoB;
    private final Map<V, K> _BtoA;
    
    public BidirectionalMap(){
        _AtoB = new HashMap<K, V>();
        _BtoA = new HashMap<V, K>();
    }
    
    public synchronized void associate( K lhs, V rhs ){
        _AtoB.put(lhs,rhs);
        _BtoA.put(rhs,lhs);
    }
    
    public V lookupRHS(Object lhs){
        return _AtoB.get(lhs);
    }
    
    public K lookupLHS(Object rhs){
        return _BtoA.get(rhs);
    }
    
    public synchronized String toString(){
        StringBuffer sb = new StringBuffer();
        for (K lhs: _AtoB.keySet()) {
            V rhs = _AtoB.get(lhs);
            
            sb.append(lhs);
            sb.append("\t<==>\t");
            sb.append(rhs);
            sb.append(uk.ac.imperial.doc.kenya.passes.IJavaCode.NEWLINE);
        }
        return sb.toString();
    }
}
