/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 9, 2004
 *
 */
package uk.ac.imperial.doc.kenya.mediator.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class StreamHandler implements Runnable {

    private static final int EOF = -1;
    
    private final Reader reader;

    private final Writer writer;

    private boolean finish = false;
    
    private int c = EOF;
    
    public StreamHandler(Reader in, Writer out) {
        reader = in;
        writer = out;
    }

    public void run() {
        try {
            try {
            c = reader.read();
            } catch (NullPointerException npe) {
                c = EOF;
            }
            while (c != EOF) {
                writer.write(c);
                
                if( !reader.ready()){	// if we could block on the next read, we better flush!
                    writer.flush();		// that reader **better** be backed by a Buffered Reader
                }
                
                c = reader.read();
            }

            if (c != -1){
                new PrintWriter(writer).println();
            }
            
            writer.flush();
        } catch (IOException e) {
            /* ignore errors */
        }
        
        synchronized (this) {
            finish = true;
            notifyAll();
        }
        if( uk.ac.imperial.doc.kenya.mediator.util.JavaCode.DEBUG_OUTPUT){
            System.out.println("StreamHandler exited");
        }
    }

    public synchronized boolean isFinished() {
        return finish;
    }
    
}