/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 10-Aug-2004 by toa02
 *	Lots of this sourced from Robert Chatley's original InputReader from the original kenya.
 */
package uk.ac.imperial.doc.kenya.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;

/**
 * @author toa02 Possible future todo's: Singleton instances for each thread or
 *         something, so _lastReadFailed is a bit nicer if we have lots of
 *         threads, of course, Kenya doesn't have threads so its not too much of
 *         a worry.
 */
public class KenyaNIO implements IKenyaNIO {

    private static KenyaNIO _single;

    /**
     * Singleton method to get an IKenyaNIO instance that points at System.in.
     * 
     * @return the IKenyaNIO singleton for handling system.in
     */
    public static IKenyaNIO get() {
        if (_single == null) {
            _single = new KenyaNIO(System.in);
        }

        return _single;
    }

    /**
     * Gets a non-singleton (i.e. new) instance of an IKenyaNIO that points at
     * the given input stream.
     * 
     * @param is
     * @return
     */
    public static IKenyaNIO get(InputStream is) {
        return new KenyaNIO(is);
    }

    private InputStreamReader isr;

    private StreamTokenizer tokenizer;

    private PrintStream out = null;

    /**
     * Private constructor: only makeable by this class
     */
    private KenyaNIO(InputStream is) {
        isr = new InputStreamReader(is);
        tokenizer = new StreamTokenizer(isr);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, ' ');
        tokenizer.wordChars(33, 255);
    }

    public boolean isEOF() {
        try {
            if (tokenizer.nextToken() == StreamTokenizer.TT_EOF) {
                return true;
            } else {
                tokenizer.pushBack();
                return false;
            }
        } catch (java.io.IOException e) {
            if (out != null) {
                out.println(e.toString());
            }
        }
        return false;
    }

    public int readInt() {

        try {

            tokenizer.resetSyntax();
            tokenizer.whitespaceChars(0, ' ');
            tokenizer.wordChars(33, 255);

            if (tokenizer.nextToken() == StreamTokenizer.TT_EOF) {
                throw new IOException("End Of File found.");
            } else {
                return (int) Double.parseDouble(tokenizer.sval);
            }
        } catch (NumberFormatException nfe) {
            return readInt();
        } catch (java.io.IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double readDouble() {

        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, ' ');
        tokenizer.wordChars(33, 255);

        try {
            if (tokenizer.nextToken() == StreamTokenizer.TT_EOF) {
                throw new IOException("End Of File found.");
            } else {
                return Double.parseDouble(tokenizer.sval);
            }
        } catch (NumberFormatException nfe) {
            return readDouble();
        } catch (java.io.IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readString() {

        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, ' ');
        tokenizer.wordChars(33, 255);

        try {

            if (tokenizer.nextToken() == StreamTokenizer.TT_EOF) {
                throw new IOException("End Of File found.");
            } else {
                return tokenizer.sval;
            }
        } catch (java.io.IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char readChar() {

        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(' ', ' ');

        try {
            if (tokenizer.nextToken() == StreamTokenizer.TT_EOF) {
                throw new IOException("End Of File found.");
            } else {
                return (char) tokenizer.ttype;
            }
        } catch (java.io.IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char read() {

        char c = ' ';
        try {
            c = (char) isr.read();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.nio.IKenyaNIO#failedLastRead()
     */
    public boolean failedLastRead() {
        return false;
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

}