/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.passes;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import uk.ac.imperial.doc.kenya.minijava.node.AExpActualParamList;
import uk.ac.imperial.doc.kenya.minijava.node.AListActualParamList;
import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.minijava.node.PActualParamList;
import uk.ac.imperial.doc.kenya.types.KFunction;
import uk.ac.imperial.doc.kenya.types.KType;


/**
 * Gets back strings for 
 * @author toa02
 *
 */
class RestrictedTranslator {

    static List<String[]> getParams(PActualParamList list, Map<Node,KFunction> functionMap, Map<Node,KType> typeMap, Node globalMain){
        Translator t = new Translator(functionMap,globalMain, typeMap, false);

        LinkedList<String[]> params = new LinkedList<String[]>();
        
        if( list == null ){ return params ; }
        
        while( true ){ // always dangerous :)
	        if( list instanceof AListActualParamList ){
	            AListActualParamList alapl = (AListActualParamList) list;
	            t.reset(~0);
	            alapl.getExpression().apply(t);
	            params.addFirst(t.getCodeArray());
	            list = alapl.getActualParamList();
	        }else if( list instanceof AExpActualParamList){
	            AExpActualParamList aeapl = (AExpActualParamList) list;
	            t.reset(~0);
	            aeapl.getExpression().apply(t);
	            params.addFirst(t.getCodeArray());
	            break;
	        }
        }
        
        return params;
    }
}
