/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 02-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.passes;

import uk.ac.imperial.doc.kenya.errors.KenyaBadLocationError;
import uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter;
import uk.ac.imperial.doc.kenya.minijava.node.AAndBoolTerm;
import uk.ac.imperial.doc.kenya.minijava.node.AArrayAllocate;
import uk.ac.imperial.doc.kenya.minijava.node.ADivTerm;
import uk.ac.imperial.doc.kenya.minijava.node.AEqEquality;
import uk.ac.imperial.doc.kenya.minijava.node.AGtRelational;
import uk.ac.imperial.doc.kenya.minijava.node.AGteqRelational;
import uk.ac.imperial.doc.kenya.minijava.node.ALtRelational;
import uk.ac.imperial.doc.kenya.minijava.node.ALteqRelational;
import uk.ac.imperial.doc.kenya.minijava.node.AMinusMathExpression;
import uk.ac.imperial.doc.kenya.minijava.node.AMinusUnaryExp;
import uk.ac.imperial.doc.kenya.minijava.node.AModTerm;
import uk.ac.imperial.doc.kenya.minijava.node.AMultTerm;
import uk.ac.imperial.doc.kenya.minijava.node.ANegateUnaryExp;
import uk.ac.imperial.doc.kenya.minijava.node.ANeqEquality;
import uk.ac.imperial.doc.kenya.minijava.node.AOrBoolExpression;
import uk.ac.imperial.doc.kenya.minijava.node.APlusMathExpression;
import uk.ac.imperial.doc.kenya.minijava.node.APlusUnaryExp;
import uk.ac.imperial.doc.kenya.minijava.node.AXorBoolExpression;
import uk.ac.imperial.doc.kenya.minijava.node.Node;

/**
 * Used to check if this is a SingleVariableExpression
 * @author toa02
 *
 */
class SingleVariableExpressionChecker extends DepthFirstAdapter {

    static boolean isSingleVariableExpression(Node node){
        
        SingleVariableExpressionChecker svec = new SingleVariableExpressionChecker();
        
        node.apply(svec);
        return svec._sve;
        
    }

    private boolean _sve;
    private SingleVariableExpressionChecker(){
        _sve = true;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAOrBoolExpression(uk.ac.imperial.doc.kenya.minijava.node.AOrBoolExpression)
     */
    public void caseAOrBoolExpression(AOrBoolExpression node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAXorBoolExpression(uk.ac.imperial.doc.kenya.minijava.node.AXorBoolExpression)
     */
    public void caseAXorBoolExpression(AXorBoolExpression node) {
        _sve = false;
        return;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAAndBoolTerm(uk.ac.imperial.doc.kenya.minijava.node.AAndBoolTerm)
     */
    public void caseAAndBoolTerm(AAndBoolTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAEqEquality(uk.ac.imperial.doc.kenya.minijava.node.AEqEquality)
     */
    public void caseAEqEquality(AEqEquality node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseANeqEquality(uk.ac.imperial.doc.kenya.minijava.node.ANeqEquality)
     */
    public void caseANeqEquality(ANeqEquality node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseALtRelational(uk.ac.imperial.doc.kenya.minijava.node.ALtRelational)
     */
    public void caseALtRelational(ALtRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAGtRelational(uk.ac.imperial.doc.kenya.minijava.node.AGtRelational)
     */
    public void caseAGtRelational(AGtRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseALteqRelational(uk.ac.imperial.doc.kenya.minijava.node.ALteqRelational)
     */
    public void caseALteqRelational(ALteqRelational node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAGteqRelational(uk.ac.imperial.doc.kenya.minijava.node.AGteqRelational)
     */
    public void caseAGteqRelational(AGteqRelational node) {
        _sve = false;
        return;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAPlusMathExpression(uk.ac.imperial.doc.kenya.minijava.node.APlusMathExpression)
     */
    public void caseAPlusMathExpression(APlusMathExpression node) {
        _sve = false;
        return;
    }
    
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAMinusMathExpression(uk.ac.imperial.doc.kenya.minijava.node.AMinusMathExpression)
     */
    public void caseAMinusMathExpression(AMinusMathExpression node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAMultTerm(uk.ac.imperial.doc.kenya.minijava.node.AMultTerm)
     */
    public void caseAMultTerm(AMultTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAModTerm(uk.ac.imperial.doc.kenya.minijava.node.AModTerm)
     */
    public void caseAModTerm(AModTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseADivTerm(uk.ac.imperial.doc.kenya.minijava.node.ADivTerm)
     */
    public void caseADivTerm(ADivTerm node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAMinusUnaryExp(uk.ac.imperial.doc.kenya.minijava.node.AMinusUnaryExp)
     */
    public void caseAMinusUnaryExp(AMinusUnaryExp node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAPlusUnaryExp(uk.ac.imperial.doc.kenya.minijava.node.APlusUnaryExp)
     */
    public void caseAPlusUnaryExp(APlusUnaryExp node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseANegateUnaryExp(uk.ac.imperial.doc.kenya.minijava.node.ANegateUnaryExp)
     */
    public void caseANegateUnaryExp(ANegateUnaryExp node) {
        _sve = false;
        return;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter#caseAArrayAllocate(uk.ac.imperial.doc.kenya.minijava.node.AArrayAllocate)
     */
    public void caseAArrayAllocate(AArrayAllocate node) {
        throw KenyaBadLocationError.get();
    }
}
