/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 15-Jul-2004 by toa02
 * With a bit of help from Vim and regular expressions
 * (and eclipse & import management)
 */
package uk.ac.imperial.doc.kenya.passes;

import uk.ac.imperial.doc.kenya.errors.KenyaInternalError;
import uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter;
import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.minijava.node.TAnd;
import uk.ac.imperial.doc.kenya.minijava.node.TAssert;
import uk.ac.imperial.doc.kenya.minijava.node.TAssign;
import uk.ac.imperial.doc.kenya.minijava.node.TBlank;
import uk.ac.imperial.doc.kenya.minijava.node.TBoolean;
import uk.ac.imperial.doc.kenya.minijava.node.TBracketPair;
import uk.ac.imperial.doc.kenya.minijava.node.TBreak;
import uk.ac.imperial.doc.kenya.minijava.node.TCase;
import uk.ac.imperial.doc.kenya.minijava.node.TChar;
import uk.ac.imperial.doc.kenya.minijava.node.TCharliteral;
import uk.ac.imperial.doc.kenya.minijava.node.TColon;
import uk.ac.imperial.doc.kenya.minijava.node.TComma;
import uk.ac.imperial.doc.kenya.minijava.node.TComment;
import uk.ac.imperial.doc.kenya.minijava.node.TConst;
import uk.ac.imperial.doc.kenya.minijava.node.TDefault;
import uk.ac.imperial.doc.kenya.minijava.node.TDivide;
import uk.ac.imperial.doc.kenya.minijava.node.TDot;
import uk.ac.imperial.doc.kenya.minijava.node.TDouble;
import uk.ac.imperial.doc.kenya.minijava.node.TDpnumber;
import uk.ac.imperial.doc.kenya.minijava.node.TElse;
import uk.ac.imperial.doc.kenya.minijava.node.TEnum;
import uk.ac.imperial.doc.kenya.minijava.node.TEqual;
import uk.ac.imperial.doc.kenya.minijava.node.TFalse;
import uk.ac.imperial.doc.kenya.minijava.node.TFor;
import uk.ac.imperial.doc.kenya.minijava.node.TGreater;
import uk.ac.imperial.doc.kenya.minijava.node.TGreaterequal;
import uk.ac.imperial.doc.kenya.minijava.node.TIdentifier;
import uk.ac.imperial.doc.kenya.minijava.node.TIf;
import uk.ac.imperial.doc.kenya.minijava.node.TInt;
import uk.ac.imperial.doc.kenya.minijava.node.TIntnumber;
import uk.ac.imperial.doc.kenya.minijava.node.TKlass;
import uk.ac.imperial.doc.kenya.minijava.node.TLBrace;
import uk.ac.imperial.doc.kenya.minijava.node.TLBracket;
import uk.ac.imperial.doc.kenya.minijava.node.TLParenthese;
import uk.ac.imperial.doc.kenya.minijava.node.TLess;
import uk.ac.imperial.doc.kenya.minijava.node.TLessequal;
import uk.ac.imperial.doc.kenya.minijava.node.TMinus;
import uk.ac.imperial.doc.kenya.minijava.node.TMinusminus;
import uk.ac.imperial.doc.kenya.minijava.node.TMod;
import uk.ac.imperial.doc.kenya.minijava.node.TNew;
import uk.ac.imperial.doc.kenya.minijava.node.TNewLine;
import uk.ac.imperial.doc.kenya.minijava.node.TNot;
import uk.ac.imperial.doc.kenya.minijava.node.TNotequal;
import uk.ac.imperial.doc.kenya.minijava.node.TNull;
import uk.ac.imperial.doc.kenya.minijava.node.TOr;
import uk.ac.imperial.doc.kenya.minijava.node.TPlus;
import uk.ac.imperial.doc.kenya.minijava.node.TPlusplus;
import uk.ac.imperial.doc.kenya.minijava.node.TRBrace;
import uk.ac.imperial.doc.kenya.minijava.node.TRBracket;
import uk.ac.imperial.doc.kenya.minijava.node.TRParenthese;
import uk.ac.imperial.doc.kenya.minijava.node.TReturn;
import uk.ac.imperial.doc.kenya.minijava.node.TSemicolon;
import uk.ac.imperial.doc.kenya.minijava.node.TString;
import uk.ac.imperial.doc.kenya.minijava.node.TStringliteral;
import uk.ac.imperial.doc.kenya.minijava.node.TSwitch;
import uk.ac.imperial.doc.kenya.minijava.node.TTimes;
import uk.ac.imperial.doc.kenya.minijava.node.TTraditionalComment;
import uk.ac.imperial.doc.kenya.minijava.node.TTrue;
import uk.ac.imperial.doc.kenya.minijava.node.TVoid;
import uk.ac.imperial.doc.kenya.minijava.node.TWhile;
import uk.ac.imperial.doc.kenya.minijava.node.TXor;

/**
 * Depth first navigator that find the first token it can and then gives back
 * its line Number and Character Position in a 2D array.
 * @author toa02
 *
 */
class TokenPositionFinder extends DepthFirstAdapter {

   private static TokenPositionFinder _single; 

   static int[] find(Node node){
      if( _single == null ){
	 _single = new TokenPositionFinder();
      }

      try{
	 node.apply(_single);
      }catch(FoundPos fp){
	 return fp.getPos();
      }

      throw new KenyaInternalError("Could not find co-ordinates for a token. Mmmm.");
   }

   private TokenPositionFinder(){ /* not construcatable */ }


   public void caseTNewLine(TNewLine node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBlank(TBlank node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTComment(TComment node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTraditionalComment(TTraditionalComment node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBoolean(TBoolean node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTChar(TChar node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTInt(TInt node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDouble(TDouble node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTString(TString node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTVoid(TVoid node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTKlass(TKlass node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTConst(TConst node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIf(TIf node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTElse(TElse node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTWhile(TWhile node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTReturn(TReturn node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTSwitch(TSwitch node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTCase(TCase node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBreak(TBreak node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDefault(TDefault node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTFor(TFor node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAssert(TAssert node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNew(TNew node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTEnum(TEnum node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTrue(TTrue node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTFalse(TFalse node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNull(TNull node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAnd(TAnd node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTOr(TOr node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTXor(TXor node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNot(TNot node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIdentifier(TIdentifier node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTStringliteral(TStringliteral node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTCharliteral(TCharliteral node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLParenthese(TLParenthese node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRParenthese(TRParenthese node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLBrace(TLBrace node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRBrace(TRBrace node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLBracket(TLBracket node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTRBracket(TRBracket node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTBracketPair(TBracketPair node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTSemicolon(TSemicolon node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTColon(TColon node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTComma(TComma node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDot(TDot node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTPlus(TPlus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTPlusplus(TPlusplus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMinus(TMinus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMinusminus(TMinusminus node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTTimes(TTimes node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDivide(TDivide node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTMod(TMod node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLess(TLess node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTLessequal(TLessequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTGreater(TGreater node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTGreaterequal(TGreaterequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTEqual(TEqual node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTNotequal(TNotequal node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTAssign(TAssign node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTIntnumber(TIntnumber node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

   public void caseTDpnumber(TDpnumber node){
      throw new FoundPos(node.getLine(),node.getPos(),node.getText().trim().length());
   }

}


