/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 04-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces;

/**
 * The representation of a "Type" defined within the code and /or a
 * placeholder for types used within functions and other classes.
 * 
 * If this IClass represents (e.g.) an Array of something, the name will
 * have [] after it, but everything else will be as the underlying class
 * would return.
 * If this is a bound class ( Class<int> as opposed to Class<Template> ) then
 * the getTemplateParams will be updated as necessary to point to the correct
 * class types.
 * @author toa02
 *
 */
public interface IClass {
  
    /**
     * The String representation of this class/type. If this class/type is not a
     * simple class but say an array of a class, then the name will be altered to
     * show this but other thing will be passed to the underlying class.
     * @return String representing the name of this class / type,
     */
    public String getName();
 
    /**
     * @return ISourceCodeLocation of where this class is defined
     * null if this is not appropriate (e.g. basic type class)
     */
    public ISourceCodeLocation getPosition();
    
    /**
     * @return A non-null array of the TemplateParameters of this class, and they're
     * "IClass", be that bound or unbound ( see comment above).
     */
    public IClass[] getTemplateParams();

    /**
     * @return A never-null array of the variable declarations in this class
     * For enumeration classes, this will be empty.
     */
    public IVariable[] getDeclarations();
    
    /**
     * @return true iff this IClass represents an enumeration
     */
    public boolean isEnum();
    
    /**
     * @return true iff this IClass represents an array
     */
    public boolean isArray();
    
    /**
     * @return true iff this IClass represents a class
     */
    public boolean isClass();
    
    /**
     * @return true iff this IClass represents a basic class/type
     */
    public boolean isBasic();
    
    /**
     * @return true iff this class represents a parameterised type
     */
    public boolean isParam();
    
    /**
     * @return A never-null array of the enumeration type constants in this class.
     * For normal classes, this will be empty. 
     */
    public String[] getEnumConstants();
    
    /**
     * @return A near-copy of this IClass where all the children who are type-paramters
     * have the correct names.
     */
    public IClass normalise();
}
