/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 04-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces;

import uk.ac.imperial.doc.kenya.minijava.node.AFuncDecDeclaration;

/**
 * Holds a repres
 * @author toa02
 *
 */
public interface IFunction {

    /**
     * @return A never-null IClass[] of the type parameters used by this function ( in order of definition )
     */
    public IClass[] getTypeParams();
    
    /**
     * @return String name of this function.
     */
    public String getName();
    
    /**
     * @return The IClass that this IFunction returns
     */
    public IClass getReturnType();
    
    /**
     * @return A never-null Array of the type & names of the arguments to this function call
     */
    public IVariable[] getArguments();

    /**
     * @return The node on the sableCC ast tree where this function was declared
     */
    public AFuncDecDeclaration getDeclarationNode();
    
    /**
     * @return SourceCodeLocation of where this function is declared
     */
    public ISourceCodeLocation getPosition();
    
    
    /**
     * @return A near-copy of this IFunction where all children that are type-parameters
     * have the right names.  (Don't worry about this, IStackMachineInformationProvider pre-calls this)
     */
    public IFunction normalise();
}
