/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 20-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.sourceCodeInformation.util;

import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;

/**
 * @author toa02
 *  
 */
public class SourceCodeLocation implements ISourceCodeLocation {

    final int _ln;

    final int _pos;

    final int _length;

    public SourceCodeLocation(int ln, int pos, int length) {
        _ln = ln;
        _pos = pos;
        _length = length;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation#getColumnNumber()
     */
    public int getColumnNumber() {
        return _pos;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation#getLineNumber()
     */
    public int getLineNumber() {
        return _ln;
    }

    /**
     * @see uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation#getTokenLength()
     */
    public int getTokenLength() {
        return _length;
    }

    public String toString() {
        return "[" + _ln + "," + _pos + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj instanceof ISourceCodeLocation) {
            ISourceCodeLocation loc = (ISourceCodeLocation) obj;
            return loc.getColumnNumber() == _pos && loc.getLineNumber() == _ln
                    && loc.getTokenLength() == _length;
        } else {
            return false;
        }
    }

    public int hashCode() {
        return (_ln << 20) + (_pos << 10) + (_length); 
    }

    public int compareTo(ISourceCodeLocation location) {
        if(location.equals(this)) {
            return 0;
        }
        
        int res = Integer.valueOf(getLineNumber()).compareTo(location.getLineNumber());
        if(res != 0 ) { return res; }
        
        res = Integer.valueOf(getColumnNumber()).compareTo(location.getColumnNumber());
        if(res != 0 ) { return res; }
        
        res = Integer.valueOf(getTokenLength()).compareTo(location.getTokenLength());
        if(res != 0) { return res; }
        
        throw new AssertionError("Equal and yet, not equal...mmmm");
    }
}