package uk.ac.imperial.doc.kenya.stackMachine;

import java.io.InputStream;
import java.io.PrintStream;

import uk.ac.imperial.doc.kenya.stackMachine.scope.IClosureScope;
import uk.ac.imperial.doc.kenya.stackMachine.scope.IMethodScope;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedClass;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IType;

public interface IStackMachine {
    
    public IMethodScope getMethodScope();

    public void setMethodScope(IMethodScope scope);

    public IClosureScope getClosureScope();

    public void setClosureScope(IClosureScope scope);
    
    public void push(IType object);
    
    public IType pop();
    
    public void printStackPeek();
    
    public void printlnStackPeek();
    
    public void print(String value);

    public void println(String value);

    public void println();

    public void invokeMethod(String method);

    public void invokeMethod(IInterpretedClass targetClass, String methodName);

    public void invokeMethod(IInterpretedClassInstance targetClass,
            String methodName);

    public void addPositionReachedListener(IPointListener listener);

    public void removePositionReachedListener(IPointListener listener);

    public void positionReached(final Object data);
    
    public void resume();
   
    public void step();

    public void setStepMode(boolean value);

    public boolean getStepMode();

    public InputStream getIn();

    public void setIn(InputStream in);

    public PrintStream getErr();

    public void setErr(PrintStream err);

    public PrintStream getOut();

    public void setOut(PrintStream out);

    public void shutdown();

}

