/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 06-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine;

import java.util.ArrayList;
import java.util.List;

import uk.ac.imperial.doc.kenya.stackMachine.scope.IClosureScope;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractHaltableClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IBuildableClosure;

/**
 * Instances of this class should be used to construct closures which are then
 * used as method bodies and arguements to the ControlFlowOpsFactory methods.
 * This is the basic building block of all closures that are to be constructed
 * at run time.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class InterpretedBuildableClosure extends AbstractHaltableClosure
        implements IBuildableClosure {

    private final List<IAtomicClosure> instructions = new ArrayList<IAtomicClosure>();

    private IAtomicClosure currentInstruction = null;

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethodBody#execute(org.wellquite.kenya.stackMachine.StackMachine)
     */
    public synchronized void execute(IStackMachine sm) {
        IClosureScope scope = getClosureScope();
        if (scope == null)
                throw new IllegalStateException(
                        "Can't execute closure without a scope.");
        
        for (int idx = 0; idx < instructions.size() && !scope.getReturn(); idx++) {
            currentInstruction = (IAtomicClosure) instructions.get(idx);
            ClosureMiscHelper.executeClosureInScope(scope, currentInstruction,
                    sm);
        }
    }

    public synchronized void addClosure(IAtomicClosure op) {
        if (op == null)
                throw new RuntimeException("Attempt to add null closure.");
        instructions.add(op);
    }

    public synchronized String toString() {
        return "BuildableClosure:\n\t" + instructions;
    }

}