/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 22-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine;

import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;

/**
 * Instances of this class represent enumerations. Variables represented by
 * IEnumType can have their value set to values of instances of this class.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class InterpretedEnumeration implements IInterpretedEnumeration {

    private Object[] values = null;

    private String name;

    //>>>toa02
    public InterpretedEnumeration(String name, Object[] values) {
        this.name = name;
        this.values = values;
    }

    //<<<toa02

    public InterpretedEnumeration(String n) {
        name = n;
    }

    public InterpretedEnumeration(Object[] values) {
        this.values = values;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration#getValues()
     */
    public synchronized Object[] getValues() {
        return values;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration#setValues(java.lang.Object[])
     */
    public synchronized void setValues(Object[] values) {
        if (this.values != null) {
            throw new RuntimeException(
                    "Attempt to modify available values in Enumeration after "
                            + "they've already been set.");
        } else {
            this.values = values;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration#isValidValue(java.lang.Object)
     */
    public synchronized boolean isValidValue(Object value) {
        for (int idx = 0; idx < values.length; idx++) {
            if (values[idx].equals(value))
                return true;
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration#setName(java.lang.String)
     */
    public synchronized void setName(String name) {
        this.name = name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration#getName()
     */
    public synchronized String getName() {
        return name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IInterpretedEnumeration)
            return ((IInterpretedEnumeration) obj).getValues().equals(
                    getValues())
                    && ((IInterpretedEnumeration) obj).getName().equals(
                            getName());
        else
            return false;
    }

    public int hashCode() {
        return getValues().hashCode() ^ getName().hashCode();
    }
}