/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 27-Aug-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.stackMachine.ops;


import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.AbstractAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.PrimitiveTypeFactory;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.ICharType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.INullType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.INumericType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IType;

/**
 * @author toa02
 *
 */
public class PrimitiveTypeConversionOpsFactory {

    private static final IAtomicClosure toChar = new AbstractAtomicClosure("(char)") {
        
        public void execute(IStackMachine sm) {

            IType toConvert = sm.pop();
            
            if ( toConvert instanceof INumericType ) {
                
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)
                ((INumericType)toConvert).getValue().intValue()        
                ));
                
            } else if ( toConvert instanceof ICharType ) {
                sm.push(toConvert);
            } else if( toConvert instanceof INullType ) {
                throw new NullPointerException();
            } else {
                throw new RuntimeException("Failed Precondition");
            }
            
        }
    };
    
    private static final IAtomicClosure toInt = new AbstractAtomicClosure("(int)") {
        
        public void execute(IStackMachine sm){
            
            IType toConvert = sm.pop();
            
            if ( toConvert instanceof INumericType ) {
                
                sm.push(PrimitiveTypeFactory.createPrimitiveType(
                        ((INumericType)toConvert).getValue().intValue()));
            } else if ( toConvert instanceof ICharType ) {
                sm.push( PrimitiveTypeFactory.createPrimitiveType((int)
                        ((ICharType)toConvert).getValue().charValue()));
            } else if( toConvert instanceof INullType ) {
                throw new NullPointerException();
            } else {
                throw new RuntimeException("Failed Precondition" + toConvert);
            }
            
        }
    };
    
    private static final IAtomicClosure toDouble = new AbstractAtomicClosure("(double)") {
        
        public void execute( IStackMachine sm ) {
            IType toConvert = sm.pop();
            
            if (toConvert instanceof INumericType) {
                
                sm.push(PrimitiveTypeFactory.createPrimitiveType(
                        ((INumericType) toConvert).getValue().doubleValue()));
                
            } else if (toConvert instanceof ICharType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((double) ((ICharType) toConvert)
                                .getValue().charValue()));
            } else if( toConvert instanceof INullType ) {
                throw new NullPointerException();
            } else {
                throw new RuntimeException("Failed Precondition");
            }
        }       
    };
    
    
    /**
     * The returned closure takes the INumericType / ICharType off the top of the stack and puts back
     * and ICharType with the provided type's value truncated to char as if by a cast.
     * @return
     */
    public static IAtomicClosure toChar() {
        return toChar;
    }

    
    /**
     * The returned closure takes the INumericType / ICharType off the top of the stack and puts back
     * and INumericType with the provided type's value truncated/widened to int as if by a cast.
     * @return
     */
    public static IAtomicClosure toInt() {
        return toInt;
    }
    
    /**
     * The returned closure takes the INumericType / ICharType off the top of the stack and puts back
     * and INumericType with the provided type's value widened to double as if by a cast.
     * @return
     */
    public static IAtomicClosure toDouble() {
        return toDouble;
    }
}
