/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 26-Aug-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.scope;


import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IAtomicClosure;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class ClosureScope implements IClosureScope {

    private IClosureScope previousScope = null;

    private IClosureScope nextScope = null;

    private boolean returnFromThisScope = false;
    
    private IAtomicClosure closure = null;

    public synchronized IClosureScope getPreviousScope() {
        return previousScope;
    }

    public synchronized void setPreviousScope(IClosureScope previousScope) {
        this.previousScope = previousScope;
    }

    public synchronized void switchToPreviousScope(IStackMachine sm) {
        if (previousScope == null) {
            throw new IllegalStateException(
                    "Can't switch to null previous scope.");
        } else {
            if (previousScope.getNextScope() == this) {
                previousScope.setNextScope(null);
            }
            sm.setClosureScope(getPreviousScope());
            previousScope = null;
        }
    }

    public synchronized void setReturn(boolean value) {
        this.returnFromThisScope = value;
        if (value && nextScope != null) {
            nextScope.setReturn(true);
        }
    }

    public synchronized boolean getReturn() {
        return returnFromThisScope;
    }

    public synchronized void setNextScope(IClosureScope nextScope) {
        if (this.nextScope != null && this.nextScope.getPreviousScope() == this) {
            this.nextScope.setPreviousScope(null);
        }
        this.nextScope = nextScope;
    }

    public synchronized IClosureScope getNextScope() {
        return nextScope;
    }

    public synchronized void switchToNextScope(IStackMachine sm) {
        if (getNextScope() == null) {
            throw new IllegalStateException("Can't switch to null next scope.");
        } else {
            sm.setClosureScope(getNextScope());
        }
    }

    public synchronized IAtomicClosure getClosure() {
        return closure;
    }

    public synchronized void setClosure(IAtomicClosure closure) {
        this.closure = closure;
    }
}