/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 26, 2004
 *
 */
package uk.ac.imperial.doc.kenya.stackMachine.types;


import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IAtomicClosure;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IHaltableClosure;

/**
 * @author matthew
 *  
 */
public abstract class AbstractHaltableClosure extends AbstractAtomicClosure
        implements IHaltableClosure {

    private static final String RETURNNAME = "return";
    
    public AbstractHaltableClosure() {
    	super("AbstractHaltableClosure");
    }

    private final IAtomicClosure returnClosure = new AbstractAtomicClosure(RETURNNAME) {

        public void execute(IStackMachine sm) {
            haltExecution();
        }
    };

    abstract public void execute(IStackMachine sm);

    public void haltExecution() {
        synchronized (lock) {
            if (getClosureScope() != null) getClosureScope().setReturn(true);
        }
    }

    public IAtomicClosure returnFromThisClosure() {
        return returnClosure;
    }

}