/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types;

import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.ICharType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.INumericType;

/**
 * Implementation of INumericType specifically representing Double values.
 * Calling setValue when a value is already set will throw an error.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class DoubleType implements INumericType {

    private double value = 0;

    private boolean assigned = false;

    public DoubleType() {
    }

    public DoubleType(double value) {
        this.value = value;
        assigned = true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INumericType#getValue()
     */
    public synchronized Number getValue() {
        return new Double(value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INumericType#setValue(java.lang.Number)
     */
    public synchronized void setValue(Number value) {
        if (assigned)
            modificationError(this);
        else {
            this.value = value.intValue();
            assigned = true;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public synchronized String toString() {
        return "DoubleType: " + value;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#isAssigned()
     */
    public synchronized boolean valueSet() {
        return assigned;
    }

    private static void modificationError(DoubleType variable) {
        throw new RuntimeException("Attempt made to modify String variable: "
                + variable);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#valueToString()
     */
    public String valueToString() {
        return "" + value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof INumericType)
            if (obj instanceof IntType)
                return ((INumericType) obj).getValue().intValue() == getValue()
                        .doubleValue();
            else
                return ((INumericType) obj).getValue().doubleValue() == getValue()
                        .doubleValue();
        else if (obj instanceof ICharType)
            return ((ICharType) obj).getValue().charValue() == getValue().doubleValue();
        else
            return false;
    }

    public int hashCode() {
        return getValue().hashCode();
    }

}