/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types;

import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IEnumType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;

/**
 * Basic implementation of IEnumType. Calling setValue when a value is already
 * set will throw an error.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class EnumType implements IEnumType {

    private IInterpretedEnumeration enumeration = null;

    private Object value = null;

    private boolean assigned = false;

    public EnumType() {
    }

    public EnumType(Object value, IInterpretedEnumeration enumeration) {
        if (enumeration.isValidValue(value) || value == null) {
            this.value = value;
            this.enumeration = enumeration;
            assigned = true;
        } else {
            throw new IllegalArgumentException(
                    "Attempt made to create an enumType with a value which is "
                            + "not a member of the enumeration.");
        }
    }

    public synchronized Object getValue() {
        return value;
    }

    public synchronized void setValue(Object value,
            IInterpretedEnumeration enumeration) {
        if (assigned && this.value != null)
            modificationError(this);
        else {
            if (enumeration.isValidValue(value)) {
                this.value = value;
                this.enumeration = enumeration;
                assigned = true;
            } else {
                throw new IllegalArgumentException(
                        "Attempt made to create an enumType with a value which is "
                                + "not a member of the enumeration.");
            }
        }
    }

    public synchronized String toString() {
        return "EnumType: " + value;
    }

    private static void modificationError(EnumType variable) {
        throw new RuntimeException("Attempt made to modify EnumType variable: "
                + variable);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#isAssigned()
     */
    public synchronized boolean valueSet() {
        return assigned && value != null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType#getValueClass()
     */
    public String getValueClassName() {
        return "EnumeratedType";
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IType#valueToString()
     */
    public String valueToString() {
        return value.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wellquite.kenya.stackMachine.types.interfaces.IEnumType#getEnumeration()
     */
    public synchronized IInterpretedEnumeration getEnumeration() {
        return enumeration;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEnumType)
            return ((IEnumType) obj).getValue().equals(getValue())
                    && ((IEnumType) obj).getEnumeration().equals(
                            getEnumeration());
        else
            return false;
    }

    public int hashCode() {
        if (getValue() == null)
            return getEnumeration().hashCode();
        else
            return getValue().hashCode() ^ getEnumeration().hashCode();
    }
}