/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types;

import java.util.HashMap;
import java.util.Map;

import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.IBooleanType;
import uk.ac.imperial.doc.kenya.stackMachine.types.interfaces.ICharType;


/**
 * A factory to aid in the construction of IPrimitiveType instances. You should
 * use this factory rather than trying to create IPrimitiveType instances
 * directly.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class PrimitiveTypeFactory {
    
    private static final IBooleanType trueBool = new BooleanType(true); 

    private static final IBooleanType falseBool = new BooleanType(false);
    
    private static final Map<Integer,IntType> intMap = new HashMap<Integer,IntType>();
    
    private static final Map<Double, DoubleType> doubleMap = new HashMap<Double, DoubleType>();
    
    private static final Map<Character, ICharType> charMap = new HashMap<Character, ICharType>();    

    public synchronized static IntType createPrimitiveType(int value) {
        Integer key = new Integer(value);
        if (intMap.containsKey(key)) {
            return intMap.get(key);
        } else {
            IntType it = new IntType(value);
            intMap.put(key, it);
            return it;
        }
    }

    public synchronized static DoubleType createPrimitiveType(double value) {
        Double key = new Double(value);
        if (doubleMap.containsKey(key)) {
            return doubleMap.get(key);
        } else {
            DoubleType dt = new DoubleType(value);
            doubleMap.put(key, dt);
            return dt;
        }
    }

    public static IBooleanType createPrimitiveType(boolean value) {
        if (value) {
            return trueBool;
        } else {
            return falseBool;
        }
    }

    public synchronized static ICharType createPrimitiveType(char value) {
        Character key = new Character(value);
        if (charMap.containsKey(key)) {
            return charMap.get(key);
        } else {
            ICharType ct = new CharType(value);
            charMap.put(key, ct);
            return ct;
        }
    }

    private PrimitiveTypeFactory() {

    }
}