/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types.interfaces;

/**
 * A type representing arrays. The value of the type (ie the array) can not be
 * changed after creation (ie the array is of fixed length and type). However,
 * the elements within the array can be modified.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IArrayType extends IPrimitiveType {

    /**
     * Sets the value of the type.
     * 
     * @param value
     */
    void setValue(IType[] value);

    /**
     * Returns the value of the type.
     * 
     * @return
     */
    IType[] getValue();

    /**
     * Returns the length of the array.
     * 
     * @return
     */
    int getLength();

    /**
     * Returns the element at the specified index in the array.
     * 
     * @param index
     * @return
     */
    IType get(int index);

    /**
     * Sets the element at the specified index in the array to the specified
     * value.
     * 
     * @param index
     * @param value
     */
    void set(int index, IType value);
}