/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 01-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types.interfaces;


import uk.ac.imperial.doc.kenya.stackMachine.IStackMachine;
import uk.ac.imperial.doc.kenya.stackMachine.scope.IClosureScope;

/**
 * Represents a closure which can not be stopped one executed. The closure may
 * represent many instructions or none.
 * 
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IAtomicClosure {

    /**
     * Execute the closure on the supplied StackMachine. The closure should only
     * make calls to the StackMachine, as all of the provided closures in the
     * various OpsFactories do.
     * 
     * @param sm
     */
    void execute(IStackMachine sm);
    
    void setClosureScope(IClosureScope scope);

    void unsetClosureScope(IClosureScope scope);
    
    IClosureScope getClosureScope();

}