/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 05-Jul-2004
 */
package uk.ac.imperial.doc.kenya.stackMachine.types.interfaces;

import java.util.Map;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public interface IInterpretedClassInstance {

    /**
     * Returns the class from which this class instance was created.
     * 
     * @return
     */
    IInterpretedClass getInterpretedClass();

    /**
     * Returns the method registered in this class. Firstly the class instance
     * methods (non-static) are searched. If the method is not found then the
     * class's static methods are searched. If still not found, an error is
     * thrown.
     * 
     * @param methodName
     *            The name of the method to search for.
     * @return
     */
    IInterpretedMethod getMethod(String methodName);

    /**
     * Gets a Map containing the class instance's mutable instance variables.
     * The Map returned is a map of String to IType values. It is the actual Map
     * used by the class instance - so don't break it!
     * 
     * @return
     */
    Map<String,IType> getMutableInstanceVariables();

    /**
     * Gets a Map containing the class instance's immutable instance variables.
     * The Map returned is a map of String to IType values. It is the actual Map
     * used by the class instance - so don't break it!
     * 
     * @return
     */
    Map<String,IType> getImmutableInstanceVariables();

}