package uk.ac.imperial.doc.kenya.styleCheckers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements.IfStatementStyleChecker;

public class StyleCheckerFactory {

    private static StyleCheckerFactory checkerFactory;
    
    private static final Object LOCK = new Object();
    private static boolean inited = false;
    
    public static StyleCheckerFactory getInstance() {
        synchronized (LOCK) {
           if(checkerFactory == null) {
               if(inited) {
                   throw new RuntimeException("Attempting to set up StyleCheckerFactory while setting up StyleCheckerFactory");
               }
               
               inited = true;
               checkerFactory = new StyleCheckerFactory();
           }
        }
        return checkerFactory;
    }

    private final Set<IStyleChecker> styleCheckers;
    
    private StyleCheckerFactory() {
        Set<IStyleChecker> registeredStyleChecker = new HashSet<IStyleChecker>();
        registeredStyleChecker.add(new IfStatementStyleChecker());
        
        styleCheckers = Collections.unmodifiableSet(registeredStyleChecker); 
    }


    
    public Set<IStyleChecker> getStyleCheckers() {
        return styleCheckers;
    }
    
    
    
}
