/*
 * Created on Sep 12, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements;

import java.io.StringReader;
import java.util.Collections;
import java.util.Set;

import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import uk.ac.imperial.doc.kenya.sourceCodeInformation.util.SourceCodeLocation;
import uk.ac.imperial.doc.kenya.styleCheckers.IFixSuggestion;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleChecker;
import uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements.IfStatementFinder.IfConstructs;
import uk.ac.imperial.doc.kenya.styleCheckers.util.CodeSpan;
import uk.ac.imperial.doc.kenya.styleCheckers.util.INodeMatchData;
import uk.ac.imperial.doc.kenya.styleCheckers.util.Util;
import uk.ac.imperial.doc.kenya.styleCheckers.util.CodeSpan.Pair;

public abstract class AbstractIfStatementResult  implements IStyleCheckResult {

    private final IfStatementStyleChecker checker;
    private final Set<IFixSuggestion> fixSuggestion;
    private final ISourceCodeLocation location;
    
    public AbstractIfStatementResult(INodeMatchData<IfConstructs> failedIfStat,
            IfStatementStyleChecker checker, String kenyaSourceCode) {
        this.checker = checker;
        
        String fixedCode = fixCode(failedIfStat, kenyaSourceCode);
        this.fixSuggestion = Collections.<IFixSuggestion>singleton(new IfFixSuggestion(this, fixedCode));
        
        this.location = getLocation(failedIfStat);
    }

    private ISourceCodeLocation getLocation(
            INodeMatchData<IfConstructs> failedIfStat) {
        Node root = failedIfStat.getMatchedNode(IfConstructs.Root);
        int[] loc = uk.ac.imperial.doc.kenya.passes.Util.getFirstIdent(root);
        return new SourceCodeLocation(loc[0], loc[1], 2);
    }

    private String fixCode(INodeMatchData<IfConstructs> failedIfStat,
            String kenyaSourceCode) {
        
        Node wholeIf = failedIfStat.getMatchedNode(IfConstructs.Root);
        Node condition = failedIfStat.getMatchedNode(IfConstructs.Condition);
        
        CodeSpan wholeSpan = Util.getStartAndEndOfNode(wholeIf);
        CodeSpan conditionSpan = Util.getStartAndEndOfNode(condition);
        
        Pair beforeAndAfter = wholeSpan.removeFrom(kenyaSourceCode);
        String conditionString = conditionSpan.findIn(kenyaSourceCode);
        
        return fixCode(beforeAndAfter.getBefore(), conditionString, beforeAndAfter.getAfter());
    }

    abstract String fixCode(String before, String conditionString, String after);

    public Set<IFixSuggestion> getPossibleFixes() {
        return this.fixSuggestion;
    }

    public IStyleChecker getSource() {
        return checker;
    }
    
    public ISourceCodeLocation getLocation() {
        return location;
    }

    public int getInformationNumber() {
        return 0;
    }

    public ISourceCodeLocation[] getLinkedInformation() {
        return null;
    }

    public int getPriority() {
        return 2;
    }    
    
    @Override
    public abstract String toString();
    
    public StringReader getHumanStyleMessage() {
        return new StringReader(toString());
    }
    
}
