/*
 * Created on Sep 7, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements;

import uk.ac.imperial.doc.kenya.styleCheckers.IFixSuggestion;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;

public class IfFixSuggestion implements IFixSuggestion {

    private final String fixedCode;
    private final IStyleCheckResult source;
    
    public IfFixSuggestion(IStyleCheckResult source,
            String fixedCode) {
        this.source = source;
        this.fixedCode = fixedCode;
    }

    public String getFixedSourceCode() {
        return fixedCode;
    }

    public IStyleCheckResult getSource() {
        return source;
    }

    public String getDescription() {
        return "Remove the if construct";
    }

    public String getName() {
        return "Remove useless if";
    }

}
