/*
 * Created on Sep 5, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.minijava.analysis.DepthFirstAdapter;
import uk.ac.imperial.doc.kenya.minijava.node.ABlock;
import uk.ac.imperial.doc.kenya.minijava.node.ABlockElseFollow;
import uk.ac.imperial.doc.kenya.minijava.node.ABoolexpExpression;
import uk.ac.imperial.doc.kenya.minijava.node.AElsePart;
import uk.ac.imperial.doc.kenya.minijava.node.AEmptyStatements;
import uk.ac.imperial.doc.kenya.minijava.node.AFalseBooleanliteral;
import uk.ac.imperial.doc.kenya.minijava.node.AIfStat;
import uk.ac.imperial.doc.kenya.minijava.node.AListStatements;
import uk.ac.imperial.doc.kenya.minijava.node.AReturnStatement;
import uk.ac.imperial.doc.kenya.minijava.node.ATermBoolExpression;
import uk.ac.imperial.doc.kenya.minijava.node.ATrueBooleanliteral;
import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.minijava.node.PBoolExpression;
import uk.ac.imperial.doc.kenya.minijava.node.PBooleanliteral;
import uk.ac.imperial.doc.kenya.styleCheckers.util.INodeMatchData;
import uk.ac.imperial.doc.kenya.styleCheckers.util.NodePattern;
import uk.ac.imperial.doc.kenya.styleCheckers.util.Util;

public class IfStatementFinder extends DepthFirstAdapter {

    public enum IfConstructs {
        Root, Condition;
    }


    
    /*
     * if(cond) { return true; } else { return false; }
     */
    private static final NodePattern<IfConstructs> SIMPLE_IF_STAT_PATTERN = setupPattern(ATrueBooleanliteral.class, AFalseBooleanliteral.class);

    /*
     * if(cond) {return false; } else { return true; }
     */
    private static final NodePattern<IfConstructs> SIMPLE_NEGATED_IF_STAT_PATTERN = setupPattern(AFalseBooleanliteral.class, ATrueBooleanliteral.class);
    
    
    private static NodePattern<IfConstructs> setupPattern(Class<? extends PBooleanliteral> ifLiteral, Class<? extends PBooleanliteral> elseLiteral) {
        try {
            Set<Node> generalNodes = new HashSet<Node>();
            Map<IfConstructs, Node> namedNodes = new HashMap<IfConstructs, Node>();
            
            AIfStat ifStatRoot = new AIfStat();
            
            namedNodes.put(IfConstructs.Root, ifStatRoot);
            
            Util.populateTokens(ifStatRoot, generalNodes);
            
            PBoolExpression generalBoolExpression = new ATermBoolExpression();
            generalNodes.add(generalBoolExpression);
            ifStatRoot.setBoolExpression(generalBoolExpression);
            
            namedNodes.put(IfConstructs.Condition, generalBoolExpression);
            
            {
                ABlock block = new ABlock();
                Util.populateTokens(block, generalNodes);
        
                AListStatements statList = new AListStatements();
                statList.setStatements(new AEmptyStatements());
        
                AReturnStatement retStat = new AReturnStatement();
                Util.populateTokens(retStat, generalNodes);
    
                ABoolexpExpression boolExpression = new ABoolexpExpression();
                
                PBooleanliteral ifPartBoolLiteral = ifLiteral.newInstance();
                Util.populateTokens(ifPartBoolLiteral, generalNodes);
                
                Util.fillInSimpleChain(boolExpression, ifPartBoolLiteral);
                
                retStat.setExpression(boolExpression);
                statList.setStatement(retStat);
                block.setStatements(statList);
                ifStatRoot.setBlock1(block);
            }
            {
                AElsePart aElsePart = new AElsePart();
                Util.populateTokens(aElsePart,generalNodes);
                
                ABlockElseFollow aBlockElseFollow = new ABlockElseFollow();
                ABlock block = new ABlock();
                Util.populateTokens(block, generalNodes);
                AListStatements aListStatements = new AListStatements();
                aListStatements.setStatements(new AEmptyStatements());
                
                AReturnStatement returnStatement = new AReturnStatement();
                Util.populateTokens(returnStatement,generalNodes);
    
                ABoolexpExpression aboolExpExpression = new ABoolexpExpression();
                
                PBooleanliteral elseBooleanLiteral = elseLiteral.newInstance();
                Util.populateTokens(elseBooleanLiteral, generalNodes);
                
                Util.fillInSimpleChain(aboolExpExpression, elseBooleanLiteral);
                
                returnStatement.setExpression(aboolExpExpression);
                aListStatements.setStatement(returnStatement);
                block.setStatements(aListStatements);
                aBlockElseFollow.setBlock(block);
                aElsePart.setElseFollow(aBlockElseFollow);
                ifStatRoot.setElsePart(aElsePart);
            }

            return new NodePattern<IfConstructs>(ifStatRoot, generalNodes, namedNodes);

        } catch(IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch(InstantiationException e ) {
            throw new RuntimeException(e);
        }
        
    }

    public static Set<INodeMatchData<IfConstructs>> findSimpleIfStatement(Node rootNode) {
        return findIfStatements(SIMPLE_IF_STAT_PATTERN, rootNode);
    }

    private static Set<INodeMatchData<IfConstructs>> findIfStatements(NodePattern<IfConstructs> pattern,
            Node rootNode) {
        IfStatementFinder sisf = new IfStatementFinder(pattern);
        rootNode.apply(sisf);
        
        return sisf.getSimpleIfStats();
    }
    
    public static Set<INodeMatchData<IfConstructs>> findNegatedSimpleIfStatement(Node rootNode) {
        return findIfStatements(SIMPLE_NEGATED_IF_STAT_PATTERN, rootNode);
    }
    
    
    private final NodePattern<IfConstructs> pattern;
    private final Set<INodeMatchData<IfConstructs>> simpleIfStatements = new HashSet<INodeMatchData<IfConstructs>>();

    
    private IfStatementFinder(NodePattern<IfConstructs> pattern) {
        super();
        this.pattern = pattern;
    }
    
    private Set<INodeMatchData<IfConstructs>> getSimpleIfStats() {
        return simpleIfStatements;
    }
    
    @Override
    public void caseAIfStat(AIfStat node) {
        super.caseAIfStat(node);

        INodeMatchData<IfConstructs> md = pattern.matches(node);
        
        if(md.success()) {
            simpleIfStatements.add(md);
        }
        
    }


}
