/*
 * Created on Sep 5, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements;

import java.util.HashSet;
import java.util.Set;

import uk.ac.imperial.doc.kenya.sourceCodeInformation.interfaces.IFunction;
import uk.ac.imperial.doc.kenya.styleCheckers.ICheckedCode;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleCheckResult;
import uk.ac.imperial.doc.kenya.styleCheckers.IStyleChecker;
import uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements.IfStatementFinder.IfConstructs;
import uk.ac.imperial.doc.kenya.styleCheckers.util.INodeMatchData;

public class IfStatementStyleChecker implements IStyleChecker {

    public Set<IStyleCheckResult> apply(ICheckedCode program) {
        
        Set<INodeMatchData<IfConstructs>> failedIfStats = new HashSet<INodeMatchData<IfConstructs>>();
        Set<INodeMatchData<IfConstructs>> negatedIfStats = new HashSet<INodeMatchData<IfConstructs>>();
        
        for(IFunction f : program.getFunctions()) {
            failedIfStats.addAll(IfStatementFinder.findSimpleIfStatement(f.getDeclarationNode()));
            negatedIfStats.addAll(IfStatementFinder.findNegatedSimpleIfStatement(f.getDeclarationNode()));
        }

        Set<IStyleCheckResult> results = new HashSet<IStyleCheckResult>();
        
        for(INodeMatchData<IfConstructs> failedIfStat : failedIfStats) {
            results.add(new SimpleIfStatementResult(failedIfStat, this, program.getKenyaSourceCode()));
        }
        
        for(INodeMatchData<IfConstructs> failedIfStat : negatedIfStats) {
            results.add(new NegatedSimpleIfStatementResult(failedIfStat, this, program.getKenyaSourceCode()));
        }
        
        return results;
        
    }

    public String getName() {
        return "Simple if statement style checker";
    }

    
    public String getDescription() {
        return "Corrects simple if(b) { return true; } else { return false; } (and vice-verca) conditions"; 
    }


}
