/*
 * Created on Sep 7, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements;

import uk.ac.imperial.doc.kenya.styleCheckers.simpleIfStatements.IfStatementFinder.IfConstructs;
import uk.ac.imperial.doc.kenya.styleCheckers.util.INodeMatchData;

public class SimpleIfStatementResult extends AbstractIfStatementResult {

    public SimpleIfStatementResult(INodeMatchData<IfConstructs> failedIfStat,
            IfStatementStyleChecker checker, String kenyaSourceCode) {
        super(failedIfStat, checker, kenyaSourceCode);
    }

    @Override
    String fixCode(String before, String conditionString, String after) {
        return before + "return " + conditionString + ";" + after;
    }

    @Override
    public String toString() {
        return "Convert the if into a simple return";
    }

 

}
