/*
 * Created on Sep 7, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.util;

public class CodeSpan {

    private final int startLine;
    private final int startCol;
    
    private final int endLine;
    private final int endCol;
    
    public CodeSpan(int startLine, int startCol, int endLine, int endCol) {
        this.startLine = startLine;
        this.startCol = startCol;
        
        this.endLine = endLine;
        this.endCol = endCol;
    }
    
    public String findIn(String source) {
        String[] lines = source.split("\n");
        String[] targetLines = new String[endLine - startLine + 1];
        
        System.arraycopy(lines,startLine-1,targetLines,0,endLine-startLine+1);

        targetLines[targetLines.length-1] = targetLines[targetLines.length-1].substring(0,endCol-1);
        targetLines[0] = targetLines[0].substring(startCol-1);
        
        String finalString = join(targetLines);
        
        return finalString.toString();
    }
    
    public Pair removeFrom(String source) {
        String[] lines = source.split("\n");
        
        String[] lhs = new String[startLine];
        String[] rhs = new String[lines.length - endLine + 1];
        
        System.arraycopy(lines,0,lhs,0,startLine);
        System.arraycopy(lines,endLine-1,rhs,0,lines.length - endLine + 1);
        lhs[startLine-1] = lhs[startLine-1].substring(0,startCol-1);
        
        rhs[0] = rhs[0].substring(endCol-1);
        
        
        String before = join(lhs);
        String after = join(rhs);
        
        return new Pair(before,after);
    }
    
    public String join(String[] strings) {
        StringBuilder finalString = new StringBuilder();
        
        for(int i = 0 ; i < strings.length ; i++ ) {
            finalString.append(strings[i]);
            if(i == strings.length - 1) {
                continue;
            }
            finalString.append('\n');
        }
        return finalString.toString();
    }
    
    public static class Pair {
        private final String before;
        private final String after;
        
        public Pair(String before, String after) {
            this.before = before;
            this.after = after;
        }
        
        public String getBefore() {
            return before;
        }
        
        public String getAfter() {
            return after;
        }
    }
}
