/*
 * Created on Sep 7, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.util;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.util.PackageReflection;

public class NodeDatabase {

    private static NodeDatabase instance;

    public static synchronized NodeDatabase getInstance() {
        if (instance == null) {
            instance = new NodeDatabase();
        }
        return instance;
    }

    private final Set<Class< ? extends Node >> allNodeClasses;

    private final Set<Class< ? extends Node >> concreteClasses;

    private final Map<Class< ? extends Node >, Set<Class< ? extends Node >>> subclasses;

    public Set<Class< ? extends Node >> getAllNodeClasses() {
        return allNodeClasses;
    }

    public Set<Class< ? extends Node >> getConcreteClasses() {
        return concreteClasses;
    }

    public Map<Class< ? extends Node >, Set<Class< ? extends Node >>> getSubclasses() {
        return subclasses;
    }

    private NodeDatabase() {

        Set<Class< ? extends Node >> allNodeClasses = loadNodeClasses();

        Map<Class< ? extends Node >, Set<Class< ? extends Node >>> subclasses = calculateSubclasses(allNodeClasses);

        Set<Class< ? extends Node >> concreteClasses = filterConcreteClasses(allNodeClasses);

        this.allNodeClasses = Collections.unmodifiableSet(allNodeClasses);
        this.concreteClasses = Collections.unmodifiableSet(concreteClasses);
        this.subclasses = Collections.unmodifiableMap(subclasses);
    }

    private Set<Class< ? extends Node >> filterConcreteClasses(Set<Class< ? extends Node >> nodeClasses) {
        Set<Class< ? extends Node >> concreteClasses = new HashSet<Class< ? extends Node >>();
        for (Class< ? extends Node > c : nodeClasses) {
            int mods = c.getModifiers();

            if (Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
                continue;
            }

            concreteClasses.add(c);
        }

        return concreteClasses;
    }

    private Map<Class< ? extends Node >, Set<Class< ? extends Node >>> calculateSubclasses(
            Set<Class< ? extends Node >> nodeClasses) {

        Map<Class< ? extends Node >, Set<Class< ? extends Node >>> subclasses = new HashMap<Class< ? extends Node >, Set<Class< ? extends Node >>>();

        for (Class< ? extends Node > c : nodeClasses) {
            for (Class< ? extends Node > cc : nodeClasses) {
                if (c.equals(cc)) {
                    continue;
                }

                if (cc.isAssignableFrom(c)) {
                    // i.e. you can do cc = c
                    // i.e. c is a subclass of cc

                    Set<Class< ? extends Node >> subsOfcc = subclasses.get(cc);

                    if (subsOfcc == null) {
                        subsOfcc = new HashSet<Class< ? extends Node >>();
                        subclasses.put(cc, subsOfcc);
                    }

                    subsOfcc.add(c);
                }
            }
        }

        return subclasses;
    }
    
    @SuppressWarnings("unchecked")
    private Set<Class< ? extends Node >> loadNodeClasses() {
        String nodePackage = Node.class.getPackage().getName();
        Set<Class< ? extends Node >> nodeClasses = new HashSet<Class< ? extends Node >>();
        
        List<String> classes = PackageReflection.getPackageClasses(nodePackage);
        for(String className : classes) {
            try {
                nodeClasses.add((Class<? extends Node>)Class.forName(nodePackage + "."
                        + className));
            } catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        return nodeClasses;
    }

}
