/*
 * Created on Sep 5, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.minijava.node.Node;

public class NodePattern<T> {

    private final Node rootNode;
    private final Set<? extends Node> matchAnythingNodes;
    private final Map<T, ? extends Node> namedNodes;
    
    
    public NodePattern(Node rootNode, Set<? extends Node> matchAnythingNodes, Map<T, ? extends Node> namedNodes) {
        this.rootNode = rootNode;
        this.matchAnythingNodes = matchAnythingNodes;
        this.namedNodes = namedNodes;
    }
    
    public INodeMatchData<T> matches(Node otherNode) {
        Map<Node, Node> equivalents = new HashMap<Node, Node>();
        if(NodePatternMatcher.getInstance().calculateMatches(rootNode, otherNode, matchAnythingNodes, equivalents)) {
            
            Map<T, ? extends Node> translatedNodes = translate(equivalents, namedNodes);
            return new SuccessfulNodeMatch<T>(translatedNodes);
        }
        
        return new FailedNodeMatch<T>();
    }

    private Map<T, ? extends Node> translate(Map<Node, Node> equivalents,
            Map<T, ? extends Node> namedNodes) {
        Map<T,Node> translatedNodes = new HashMap<T,Node> ();
        for(Map.Entry<T,? extends Node> entry : namedNodes.entrySet()) {
            translatedNodes.put(entry.getKey(),equivalents.get(entry.getValue()));
        }
        
        return translatedNodes;
    }
    
}
