/*
 * Created on Sep 5, 2006
 */
package uk.ac.imperial.doc.kenya.styleCheckers.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.minijava.node.Token;

public class NodePatternMatcher {

    private static NodePatternMatcher instance;

    static synchronized NodePatternMatcher getInstance() {
        if (instance == null) {
            instance = new NodePatternMatcher();
        }
        return instance;
    }

    private NodePatternMatcher() {
    }
    
    /**
     * Calculates if the pattern and target node match,
     * populating equivalents with the matching pairs
     * pattern -> target as it goes.
     * @param patternNode
     * @param targetNode
     * @param matchAnythingNodes
     * @param equivalents
     * @return
     */
    public boolean calculateMatches(Node patternNode, Node targetNode, Set<? extends Node> matchAnythingNodes, Map<Node, Node> equivalents) {

        if(matchAnythingNodes.contains(patternNode)) {
            equivalents.put(patternNode, targetNode);
            return true;
        }
            
        if(patternNode == null && targetNode != null ||
           patternNode != null && targetNode == null) {
            return false;
        }
        
        if(patternNode == null && targetNode == null) {
            return true;
        }
        
        if(!patternNode.getClass().equals(targetNode.getClass())){
            return false;
        }
        
        if(patternNode instanceof Token) {
            Token patternToken = (Token) patternNode;
            Token targetToken = (Token) targetNode;
            if(patternToken.getText().trim().equals(targetToken.getText().trim())) {
                equivalents.put(patternNode, targetNode);
                return true;
            } else {
                return false;
            }
        }
        
        try {
            for (Method m : getNodeAccessorMethods(patternNode.getClass())) {
                Node patternStep = (Node) m.invoke(patternNode);
                Node targetStep = (Node) m.invoke(targetNode);
                if (!calculateMatches(patternStep, targetStep, matchAnythingNodes, equivalents)) {
                    return false;
                }
            }
        
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }

        equivalents.put(patternNode, targetNode);
        return true;
        
    }
    
    private Map<Class<? extends Node>, List<Method>> cachedMethods = new HashMap<Class<? extends Node>, List<Method>>();
    
    /*
     * Caching Method objects is always a good thing.
     */
    private List<Method> getNodeAccessorMethods(Class<? extends Node> c) {
        List<Method> methodList = cachedMethods.get(c);
        if(methodList != null) {
            return methodList;
        }
        
        methodList = Util.getNodeAccessorMethods(c);
        
        cachedMethods.put(c,methodList);
        return methodList;
    }


    
}
