/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jun-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.types;

import java.util.Map;

import uk.ac.imperial.doc.kenya.errors.KenyaPreconditionError;
import uk.ac.imperial.doc.kenya.types.tables.TypeTable;


/**
 * @author toa02
 *
 */
public class KArrayType extends KType {

	private KType _child;
	public KArrayType(KType child){
	    _child = child;
	    if(_child.equals(KBasicType.getVoid()) ){
			throw KenyaPreconditionError.get();
		}
		_child = child;
	}
	

	/**
	 * @see uk.ac.imperial.doc.kenya.types.KType#getName()
	 */
	public String getName() {
		return _child.getName() + "[]";
	}
	
	public KType getChildType(){
		return _child;
	}
	
	public String toString(){
		return getName();
	}
	
	/**
	 * @return int representing how deep the nesting on this array type is.
	 * ( non recursive )
	 */
	public int getDepth(){
	    int i = 1;
	    KType child = _child;
	    while( child instanceof KArrayType){
	        child = ((KArrayType)child)._child;
	        i++;
	    }
	    return i;
	}
	
	/**
	 * @see uk.ac.imperial.doc.kenya.types.KType#bind(uk.ac.imperial.doc.kenya.types.tables.TypeTable)
	 */
	public KType bind(TypeTable tt){
	    // By the pre-cond that this child is not null, so
	    // neither should a bound child :)
	    return new KArrayType( _child.bind(tt));
	}
	
	
	/**
	 * Returns the underlying type of this
	 * (possibly nested depth) array.
	 * @return
	 */
	public KType getBaseType(){
	    KType child = _child;
	    while( child instanceof KArrayType){
	        child = ((KArrayType)child)._child;
	    }
	    return child;
	}
	
	/**
     * @see uk.ac.imperial.doc.kenya.types.KType#compareAndBind(uk.ac.imperial.doc.kenya.types.KType, uk.ac.imperial.doc.kenya.types.tables.TypeTable)
     */
    public int compareAndBind(KType target, TypeTable tt) {
        if( target instanceof KArrayType){
            KArrayType kat = (KArrayType) target;
            
            KType mc = _child.bind(tt);
            KType tc = kat._child.bind(tt);
            if( mc instanceof KBasicType || tc instanceof KBasicType ){
                if( mc != tc && tc != KBasicType.getString() ){ return -1; }	// array children have to be of the same type.
            }

            //if either are of basic type before binding?
            if ( ( getChildType() instanceof KParamType && 
                    kat.getChildType() instanceof KBasicType && 
                    kat.getBaseType() != KBasicType.getString() ) ){
                return -2;
            }
            
            
            return _child.compareAndBind(kat.getChildType(), tt);
            
        }else if ( target == KNullType.get() ){
            return 0;
        } else {
            return -1;
        }
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KType#isBound(java.util.Map)
     */
    public boolean isBound(Map<String,KType> paramMap) {
        return _child.isBound(paramMap);
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KType#populateParamMap(java.util.Map)
     */
    public void populateParamMap(Map<String, KType> paramMap) {
        _child.populateParamMap(paramMap);
    }
}
