/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jun-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.types;

import java.util.HashMap;
import java.util.Map;

import uk.ac.imperial.doc.kenya.types.tables.TypeTable;



/**
 * @author toa02
 *
 */
public class KBasicType extends KType{
	private static Map<String, KBasicType> _preMade;
	
	private final String _name;
	private final KClassType _classType;
	
	/* Static initialiser */
	private static void setup(){
		_preMade = new HashMap<String, KBasicType>();
		_preMade.put("boolean", new KBasicType("boolean", KClassType.getBoolean()));
		_preMade.put("char", new KBasicType("char", KClassType.getCharacter()));
		_preMade.put("int", new KBasicType("int", KClassType.getInteger()));
		_preMade.put("double", new KBasicType("double", KClassType.getDouble()));
		_preMade.put("String", new KBasicType("String", null));
		_preMade.put("void", new KBasicType("void", null));
	}
	
	public synchronized static KBasicType getInt(){
		if( _preMade == null ){ setup(); }
		return _preMade.get("int");
	}
	
	public synchronized static KBasicType getBoolean() {
		if( _preMade == null ){ setup(); }
		return _preMade.get("boolean");
	}
	
	public synchronized static KBasicType getDouble(){
		if( _preMade == null ){ setup(); }
		return _preMade.get("double");
	}
	
	public synchronized static KBasicType getChar(){
		if( _preMade == null ){ setup(); }
		return _preMade.get("char");
	}
	
	public synchronized static KBasicType getVoid(){
		if( _preMade == null ){ setup(); }
		return _preMade.get("void");
	}
	
	public synchronized static KBasicType getString(){
		if( _preMade == null ){ setup(); }
		return _preMade.get("String");
	}
	
	private KBasicType(String name, KClassType classType){
		_name = name;
		_classType = classType;
	}
	

	/**
	 * @see uk.ac.imperial.doc.kenya.types.KType#getName()
	 */
	public String getName() {
		return _name;
	}
	
	/**
	 * Gives back the name representing the class that represents this basic type.
	 */
	public KClassType getClassType(){
	    return _classType;
	}
	
	public String toString(){
		return getName();
	}
	
	/**
	 * @see uk.ac.imperial.doc.kenya.types.KType#bind(uk.ac.imperial.doc.kenya.types.tables.TypeTable)
	 */
	public KType bind(TypeTable tt){
//	    if( _classType != null ){
//	        return new KBoundClassType(_classType,tt);
//	    }else{
	        return this;
//	    }
	}
	
	
	/**
     * @see uk.ac.imperial.doc.kenya.types.KType#isBound(java.util.Map)
     */
    public boolean isBound(Map<String,KType> paramMap) {
        return true;
    }

	/**
     * @see uk.ac.imperial.doc.kenya.types.KType#compareAndBind(uk.ac.imperial.doc.kenya.types.KType, uk.ac.imperial.doc.kenya.types.tables.TypeTable)
     */
    public int compareAndBind(KType target, TypeTable tt) {
        
        if( target instanceof KBoundClassType ){
            KClassType kt = ((KBoundClassType)target).getBase();
            
            if( this == getDouble() && kt == KClassType.getInteger() ){
                return 1;
            }
            
            if( this == getDouble() && kt == KClassType.getCharacter() ){
                return 2;
        	}
        
        	if( this == getInt() && kt == KClassType.getCharacter() ){
        	    return 1;
        	}
        	
        	if( this == getDouble() && kt == KClassType.getDouble() ||
        	    this == getInt() && kt == KClassType.getInteger()     ||
        	    this == getChar() && kt == KClassType.getCharacter()  ||
        	    this == getBoolean() && kt == KClassType.getBoolean() ){
        	    return 0;
        	}
            
        }
        
        if( this == getDouble() && target == getInt() ){
            return 1;
        }
        
        if( this == getDouble() && target == getChar()){
            return 2;
    	}
    
    	if( this == getInt() && target == getChar()){
    	    return 1;
    	}
    	
        if( target == this ){
            return 0;
        }
        
        return -1;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KType#populateParamMap(java.util.Map)
     */
    public void populateParamMap(Map<String, KType> paramMap) {
        return; // do nothing
    }
}
