/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jun-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.types;

import java.util.List;
import java.util.Map;

import uk.ac.imperial.doc.kenya.types.tables.TypeTable;


/**
 * @author toa02
 *
 */
public class KEnumType extends KType {

	private String _name;
	private List<String> _children;
	
	public KEnumType( String enumName, List<String> children ){
		_name = enumName;
		_children = children;
	}
	
	public boolean hasChild( String name ){
		return _children.contains(name);
	}
	
	public String getName(){
		return _name;
	}
	
	public String[] getChildren(){
	    return (String[]) _children.toArray(new String[0] );
	}
	
	/**
	 * Returns this enum's name and its children.
	 * @see java.lang.Object#toString()
	 */
	public String toString(){
		return _name;
	}
	
	/**
	 * @see uk.ac.imperial.doc.kenya.types.KType#bind(uk.ac.imperial.doc.kenya.types.tables.TypeTable)
	 */
	public KType bind(TypeTable tt){
	    return this;
	}
	
	

	/**
     * @see uk.ac.imperial.doc.kenya.types.KType#compareAndBind(uk.ac.imperial.doc.kenya.types.KType, uk.ac.imperial.doc.kenya.types.tables.TypeTable)
     */
    public int compareAndBind(KType target, TypeTable tt) {
        if( target instanceof KEnumType ){
            if( target.equals(this)){
                return 0;
            }
        } else if( target == KNullType.get() ) {
        	return 0;
        }
        
        return -1;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KType#isBound(java.util.Map)
     */
    public boolean isBound(Map<String,KType> paramMap) {
        return true;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KType#populateParamMap(java.util.Map)
     */
    public void populateParamMap(Map<String, KType> paramMap) {
        return; // do nothing
    }
}
