/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jun-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.types;

import java.util.Map;

import uk.ac.imperial.doc.kenya.types.tables.TypeTable;


/**
 * Parent type of the Types in Kenya
 * 
 * @author toa02
 *  
 */
public abstract class KType{

    
    /**
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
	public boolean equals(Object o) {

		if (o instanceof KType) {
			KType ot = (KType) o;
			return ot.getName().equals(getName());
		}

		return false;
	}

	public int hashCode() {
		return getName().hashCode();
	}

	public abstract String getName();

	/**
	 * Returns a version of this KType where all the parameterised
	 * types have been bound to their mappings in the TypeTable.
	 * @param tt TypeTable containing bindings for parameterised types.
	 * @return KType a version of this KType which has been bound according to
	 * the TypeTable mappings.
	 */
	public abstract KType bind(TypeTable tt);
	
	 /**
     * Ok this is one hellishly complicated method. I can only just conceptualize it in
     * my mind. I don't know what chance other people have.
     * Its probably entirely pointless aswell, but thats beside the (forgive the pun) point.
     * Right, what should this be doing?
     * Well...we take KType target and want to see if its compatible with this KType.
     * By compatible I mean pretty much the same, however if we are or have a KParamType, and b is/has something
     * more grounded (or even a different / the same KParamType), this "mapping" should be recorded in
     * the type table, and then on any other references to the ParamType in a should be assumed to be the
     * same as the param type in b.
     * 
     * I get the feeling the easiest way to do this is by a method in each of the KTypes. Sold.
     * Hence why this is here. (originally it was in kenya.passes.Util - well at least this comment was
     * then I moved it out here). Look, its the end of week 2 and I'm pretty tired, Big Brother has been keeping
     * me up late. Only 50 minutes to go then I can head on home. Lets get some work done...
     * 
     * This method also needs to take into accound casts between int and double, hence the return type
     * (the number of int -> double casts that have taken place. This is useful for functions.
     * 
     * This method returns -1 if there is no way to bind the two, or the number of int-> double binds that
     * have taken place. The TypeTable may be modified as a side effect. Bear that in mind!
     * 
     * Of course if there is an int type in the mapping and it later occurs that we want to use it
     * as as a double type, that *should* be allowed, because I want to allow it (and in theory java allows it).
     * 
     * @param target KType that is "more grounded" than me and should have mappings made to it.
     * @param TypeTable tt Where the mappings to be made are stored.
     * @return int This method returns -1 if there is no way to bind the two, or the number of int-> double binds that
     * have taken place. The TypeTable may be modified as a side effect. Bear that in mind!
     */
	public abstract int compareAndBind(KType target,TypeTable tt);

	
	/**
	 * @param paramMap map of Name->KParamType 
	 * @return true if for every type parameter in this type,
	 * it is mapped in the paramMap, otherwise returns false.
	 */
	public abstract boolean isBound(Map<String,KType> paramMap);
	
	/**
	 * Populates a paramMap with the parameterised types that are in this ktype tree
	 * @param paramMap
	 */
	public abstract void populateParamMap(Map<String, KType> paramMap );
}