package uk.ac.imperial.doc.kenya.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageReflection {
    
    private static final String mainClassesPattern = "[.\\w]+.class";

    public static List<String> getPackageClasses(String packageName) {
        String dirPackage = packageName.replace('.', '/');
        
        ClassLoader cld = ClassLoader.getSystemClassLoader();
        URL resource = cld.getResource(dirPackage);
        File directory = new File(resource.getFile());

        List<String> classes = resource.getProtocol().equals("file") ?
                parseDirectory(directory)
                : parseJarFile(directory, dirPackage);
                
        return classes;
    }

    private static List<String> parseDirectory(File dir) {
    	
        List<String> result = new ArrayList<String>();
    	
    	// Recursively add subfolders
        File[] builtinMethodDirectories = dir.listFiles(new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory();
        }});
        
        for (File d: builtinMethodDirectories)
        {
        	List<String> temp = parseDirectory(d);
        	for (String f: temp)
        	{
        		result.add(d.getName() + "." + f);
        	}
        }
    	
        File[] builtinMethodClasses = dir.listFiles(new FileFilter() {
            public boolean accept(File f) {
                return f.isFile() && f.getName().matches(mainClassesPattern);
        }});
        
        for (File f: builtinMethodClasses) {
            String c = f.getName();
            c.replace(".class", "");
            result.add(f.getName().replace(".class", ""));
        }
        return result;
    }
    
    private static List<String> parseJarFile(File dir, String packagePath) {
        List<String> result = new ArrayList<String>();
        try {
            JarFile jar = new JarFile(dir.getPath().substring(5, dir.getPath().indexOf("!")));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String path = entries.nextElement().getName();
                if (path.startsWith(packagePath)) {
                    // The path starts with '/'
                    String entry = (path.substring(packagePath.length() + 1)).replace("/", ".");
                    if (entry.matches(mainClassesPattern)) {
                    	result.add(entry.replace(".class", ""));
                    }
                }
            }
        } catch (IOException e) {
            return new ArrayList<String>();
        }
        return result;
    }
}

