/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 26-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.values;

/**
 * @author toa02
 *
 */
public interface IKNumericValue extends IKValue{
    
    /**
     * @return boolean true iff the value of this KNumericValue is 0
     * 	(and as such would cause a divide by zero error to occur if it where
     * 	 used on the rhs ).
     */
    public boolean equalsZero();
    
    /**
     * @return boolean true iff the value of this KNumericValue is
     * in the range that char values should be in. KDoubleValues will
     * always return false on this.
     */
    public boolean inCharRange();
    
    /**
     * @return double typed value of this IKValue ( casting up
     * where necessary).
     */
    public double getDoubleValue();
}
