/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 20-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.values;

/**
 * 2 Singleton's representing the two truth values booleans
 * can take.
 * @author toa02
 *
 */
public class KBooleanValue implements IKValue{

    private static KBooleanValue _true;
    private static KBooleanValue _false;
    
    /**
     * @return The singleton KBooleanValue 
     * representing "true"
     */
    public synchronized static KBooleanValue getTrue(){
        if( _true == null){
            _true = new KBooleanValue(true);
        }
        
        return _true;
    }
    
    public static KBooleanValue get(boolean value){
        if( value ){
            return getTrue();
        }else{
            return getFalse();
        }
    }
    
    /**
     * @return The singleton KBooleanValue
     * representing "false"
     */
    public synchronized static KBooleanValue getFalse(){
        if( _false == null ){
            _false = new KBooleanValue(false);
        }
        
        return _false;
    }
    
    
    private boolean _val;
    
    private KBooleanValue(boolean val){
        _val = val;
    }
    
    /**
     * @return boolean of the current value of this KBooleanValue
     */
    public boolean getValue(){
        return _val;
    }
    
    /**
     * @return KBooleanValue representing the negated version of
     * this KBooleanValue
     */
    public KBooleanValue getNegation(){
        return get(!_val);
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.values.IKValue#getString()
     */
    public String getString(){
        return Boolean.toString(_val);
    }

    /**
     * Yes this is the same as Object's definition, but just to be explicit...
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object o){
        return o == this;
    }
    
}
