/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 20-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.values;

import uk.ac.imperial.doc.kenya.types.KEnumType;

/**
 * @author toa02
 *
 */
public class KEnumValue implements IKValue {

    
    private KEnumType _type;
    private String _childName;
    
    public KEnumValue( KEnumType type, String child){
        if( !type.hasChild(child) ){
            throw new IllegalStateException("KEnumValue with wrong kinda child! " +
                    type + " # " + child);
        }
        
        _type = type;
        _childName = child;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.values.IKValue#getString()
     */
    public String getString() {
        return _type.getName() + "." + _childName;
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object rhs){
        if(! (rhs instanceof KEnumValue) ){ return false ;}
        
        KEnumValue rhe = (KEnumValue) rhs;
        
        return (_type.getName().equals(rhe._type.getName())) &&
        		(_childName.equals(rhe._childName));
        
    }
    
    public int hashCode(){
        return _type.hashCode() + _childName.hashCode();
    }
}
