/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/


/*
 * Created on 20-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.values;

import uk.ac.imperial.doc.kenya.errors.KenyaPreconditionError;

/**
 * Represents a value that is not known statically
 * at compile time.  Pretty much any operation applied
 * to an unknown value will result in an unknown value.
 * 
 * This is a singleton'd class.
 * 
 * @author toa02
 *
 */
public class KUnknownValue implements IKValue {
    
    private static KUnknownValue _single;
    
    private KUnknownValue(){
        // private constructor
    }
    
    /**
     * @return the singleton instance of KUnknownValue
     */
    public synchronized static KUnknownValue get(){
        if( _single == null ){
            _single = new KUnknownValue();
        }
        
        return _single;
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.values.IKValue#getString()
     */
    public String getString() {
        throw KenyaPreconditionError.get();
    }
    
    public String toString(){
        return "/Unknown/";
    }
    

}