/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on 30-Jul-2004 by toa02
 *
 */
package uk.ac.imperial.doc.kenya.values.util;

import uk.ac.imperial.doc.kenya.errors.KenyaPreconditionError;
import uk.ac.imperial.doc.kenya.minijava.node.Node;
import uk.ac.imperial.doc.kenya.types.KType;
import uk.ac.imperial.doc.kenya.types.KVariable;

/**
 * @author toa02
 */
public class MarkerKVariable extends KVariable {

    
    private static MarkerKVariable _single;
    private static MarkerKVariable _enuSingle;
    
    public static KVariable getArbitary(){
        if( _single == null ){
            _single = new MarkerKVariable();
        }
        
        return _single;
    }
    
   public static KVariable getEnumConst(){
       if( _enuSingle == null ){
           _enuSingle = new MarkerKVariable();
       }
       
       return _enuSingle;
   }
    
    
    private MarkerKVariable(){
        super(null,null,false,null);    
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KVariable#getName()
     */
    public String getName() {
        throw KenyaPreconditionError.get();
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KVariable#getNode()
     */
    public Node getNode() {
        throw KenyaPreconditionError.get();
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KVariable#getType()
     */
    public KType getType() {
        throw KenyaPreconditionError.get();
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KVariable#isConstant()
     */
    public boolean isConstant() {
        return false;
        //throw KenyaPreconditionError.get();
    }
    
    /**
     * @see uk.ac.imperial.doc.kenya.types.KVariable#toString()
     */
    public String toString() {
        return "/MarkerKVariable/";
    }
    
}
