/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.DefaultDescription;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ContentType
implements IContentType {
    static final byte ASSOCIATED_BY_EXTENSION = 2;
    static final byte ASSOCIATED_BY_NAME = 1;
    private static final String DESCRIBER_ELEMENT = "describer";
    static final byte NOT_ASSOCIATED = 0;
    public static final String PREF_DEFAULT_CHARSET = "charset";
    public static final String PREF_FILE_EXTENSIONS = "file-extensions";
    public static final String PREF_FILE_NAMES = "file-names";
    static final byte PRIORITY_HIGH = 1;
    static final byte PRIORITY_LOW = -1;
    static final byte PRIORITY_NORMAL = 0;
    static final int SPEC_PRE_DEFINED = 1;
    static final int SPEC_USER_DEFINED = 2;
    static final byte STATUS_INVALID = 2;
    static final byte STATUS_UNKNOWN = 3;
    static final byte STATUS_VALID = 1;
    private ContentType aliasTarget;
    private String baseTypeId;
    private IContentType[] children;
    private IConfigurationElement contentTypeElement;
    private String defaultCharset;
    private String userCharset;
    private IContentDescription defaultDescription;
    private IContentDescriber describer;
    private List fileSpecs;
    private ContentTypeManager manager;
    private String name;
    private String namespace;
    private byte priority;
    private String simpleId;
    private byte validation;

    public static ContentType createContentType(ContentTypeManager manager, String namespace, String simpleId, String name, byte priority, String[] fileExtensions, String[] fileNames, String baseTypeId, String defaultCharset, IConfigurationElement contentTypeElement) {
        ContentType contentType = new ContentType(manager);
        contentType.defaultDescription = new DefaultDescription(contentType);
        contentType.simpleId = simpleId;
        contentType.namespace = namespace;
        contentType.name = name;
        contentType.priority = priority;
        if (fileExtensions != null && fileExtensions.length > 0 || fileNames != null && fileNames.length > 0) {
            contentType.fileSpecs = new ArrayList(fileExtensions.length + fileNames.length);
            int i = 0;
            while (i < fileNames.length) {
                contentType.fileSpecs.add(ContentType.createFileSpec(fileNames[i], 5));
                ++i;
            }
            i = 0;
            while (i < fileExtensions.length) {
                contentType.fileSpecs.add(ContentType.createFileSpec(fileExtensions[i], 9));
                ++i;
            }
        }
        contentType.defaultCharset = defaultCharset;
        contentType.contentTypeElement = contentTypeElement;
        contentType.baseTypeId = baseTypeId;
        contentType.processPreferences();
        return contentType;
    }

    private void processPreferences() {
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        this.userCharset = contentTypeNode.get(PREF_DEFAULT_CHARSET, null);
        String userSetFileNames = contentTypeNode.get(PREF_FILE_NAMES, null);
        String[] fileNames = ContentType.parseItems(userSetFileNames);
        int i = 0;
        while (i < fileNames.length) {
            this.internalAddFileSpec(fileNames[i], 6);
            ++i;
        }
        String userSetFileExtensions = contentTypeNode.get(PREF_FILE_EXTENSIONS, null);
        String[] fileExtensions = ContentType.parseItems(userSetFileExtensions);
        int i2 = 0;
        while (i2 < fileExtensions.length) {
            this.internalAddFileSpec(fileExtensions[i2], 10);
            ++i2;
        }
    }

    static FileSpec createFileSpec(String fileSpec, int type) {
        return new FileSpec(fileSpec, type);
    }

    private static String getPreferenceKey(int flags) {
        if ((flags & 8) != 0) {
            return PREF_FILE_EXTENSIONS;
        }
        if ((flags & 4) != 0) {
            return PREF_FILE_NAMES;
        }
        throw new IllegalArgumentException("Unknown type: " + flags);
    }

    static String[] parseItems(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        if (!tokenizer.hasMoreTokens()) {
            return new String[0];
        }
        String first = tokenizer.nextToken().trim();
        if (!tokenizer.hasMoreTokens()) {
            return new String[]{first};
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(first);
        do {
            items.add(tokenizer.nextToken().trim());
        } while (tokenizer.hasMoreTokens());
        return items.toArray(new String[items.size()]);
    }

    static String toListString(List list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            result.append(i.next());
            result.append(',');
        }
        return result.substring(0, result.length() - 1);
    }

    static String toListString(Object[] list) {
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            result.append(list[i]);
            result.append(',');
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }

    public ContentType(ContentTypeManager manager) {
        this.manager = manager;
    }

    public synchronized void addFileSpec(String fileSpec, int type) throws CoreException {
        Assert.isLegal(type == 8 || type == 4, "Unknown type: " + type);
        if (this.aliasTarget != null) {
            this.getTarget().addFileSpec(fileSpec, type);
            return;
        }
        if (!this.internalAddFileSpec(fileSpec, type | 2)) {
            return;
        }
        String key = ContentType.getPreferenceKey(type);
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        Object[] userSet = this.internalGetFileSpecs(type | 1);
        contentTypeNode.put(key, ContentType.toListString(userSet));
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = Policy.bind("content.errorSavingSettings", this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int describe(IContentDescriber selectedDescriber, InputStream contents, ContentDescription description) throws IOException {
        try {
            int n;
            try {
                n = selectedDescriber.describe(contents, description);
                Object var5_5 = null;
            }
            catch (RuntimeException re) {
                this.invalidateDescriber(re);
                Object var5_6 = null;
                ((LazyInputStream)contents).rewind();
                return 0;
            }
            catch (Error e) {
                this.invalidateDescriber(e);
                throw e;
            }
            ((LazyInputStream)contents).rewind();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ((LazyInputStream)contents).rewind();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int describe(ITextContentDescriber selectedDescriber, Reader contents, ContentDescription description) throws IOException {
        try {
            int n;
            try {
                n = selectedDescriber.describe(contents, (IContentDescription)description);
                Object var5_5 = null;
            }
            catch (RuntimeException re) {
                this.invalidateDescriber(re);
                Object var5_6 = null;
                ((LazyReader)contents).rewind();
                return 0;
            }
            catch (Error e) {
                this.invalidateDescriber(e);
                throw e;
            }
            ((LazyReader)contents).rewind();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ((LazyReader)contents).rewind();
            throw throwable;
        }
    }

    public IContentType getBaseType() {
        if (this.aliasTarget != null) {
            return this.getTarget().getBaseType();
        }
        if (this.baseTypeId == null) {
            return null;
        }
        ContentType originalBaseType = this.manager.internalGetContentType(this.baseTypeId);
        return originalBaseType != null ? originalBaseType.getTarget() : null;
    }

    String getBaseTypeId() {
        return this.baseTypeId;
    }

    IContentType[] getChildren() {
        if (this.children == null) {
            this.children = this.manager.getChildren(this);
        }
        return this.children;
    }

    public String getDefaultCharset() {
        if (this.aliasTarget != null) {
            return this.getTarget().getDefaultCharset();
        }
        String currentCharset = this.userCharset != null ? this.userCharset : this.internalGetDefaultCharset();
        return "".equals(currentCharset) ? null : currentCharset;
    }

    public IContentDescription getDefaultDescription() {
        if (this.aliasTarget != null) {
            return this.getTarget().getDefaultDescription();
        }
        return this.defaultDescription;
    }

    public int getDepth() {
        ContentType baseType = (ContentType)this.getBaseType();
        if (baseType == null) {
            return 0;
        }
        return 1 + baseType.getDepth();
    }

    public IContentDescriber getDescriber() {
        if (this.aliasTarget != null) {
            return this.getTarget().getDescriber();
        }
        if ("".equals(this.contentTypeElement.getAttributeAsIs(DESCRIBER_ELEMENT))) {
            return null;
        }
        ContentType contentType = this;
        synchronized (contentType) {
            if (this.describer != null) {
                return this.describer;
            }
            if (this.contentTypeElement.getChildren(DESCRIBER_ELEMENT).length > 0 || this.contentTypeElement.getAttributeAsIs(DESCRIBER_ELEMENT) != null) {
                try {
                    this.describer = (IContentDescriber)this.contentTypeElement.createExecutableExtension(DESCRIBER_ELEMENT);
                    return this.describer;
                }
                catch (CoreException ce) {
                    return this.invalidateDescriber(ce);
                }
            }
        }
        ContentType baseType = (ContentType)this.getBaseType();
        return baseType == null ? null : baseType.getDescriber();
    }

    public IContentDescription getDescriptionFor(InputStream contents, QualifiedName[] options) throws IOException {
        LazyInputStream buffer = ContentTypeManager.readBuffer(contents);
        if (buffer == null) {
            return this.defaultDescription;
        }
        return this.internalGetDescriptionFor(buffer, options);
    }

    public IContentDescription getDescriptionFor(Reader contents, QualifiedName[] options) throws IOException {
        LazyReader buffer = ContentTypeManager.readBuffer(contents);
        if (buffer == null) {
            return this.defaultDescription;
        }
        return this.internalGetDescriptionFor(buffer, options);
    }

    public String[] getFileSpecs(int typeMask) {
        if (this.aliasTarget != null) {
            return this.getTarget().getFileSpecs(typeMask);
        }
        return this.internalGetFileSpecs(typeMask);
    }

    private String[] internalGetFileSpecs(int typeMask) {
        if (this.fileSpecs == null) {
            return new String[0];
        }
        typeMask ^= 3;
        ArrayList<String> result = new ArrayList<String>(this.fileSpecs.size());
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if ((spec.getType() & typeMask) != spec.getType()) continue;
            result.add(spec.getText());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getId() {
        return String.valueOf(this.namespace) + '.' + this.simpleId;
    }

    public String getName() {
        return this.name;
    }

    byte getPriority() {
        return this.priority;
    }

    String getSimpleId() {
        return this.simpleId;
    }

    ContentType getTarget() {
        if (this.aliasTarget == null) {
            return this;
        }
        return this.aliasTarget.getTarget();
    }

    byte getValidation() {
        return this.validation;
    }

    private boolean hasFileSpec(String text, int typeMask) {
        if (this.fileSpecs == null) {
            return false;
        }
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if (!spec.equals(text, typeMask)) continue;
            return true;
        }
        return false;
    }

    boolean internalAddFileSpec(String fileSpec, int typeMask) {
        if (this.hasFileSpec(fileSpec, typeMask)) {
            return false;
        }
        if (this.aliasTarget != null) {
            return this.aliasTarget.internalAddFileSpec(fileSpec, typeMask);
        }
        if (this.fileSpecs == null) {
            this.fileSpecs = new ArrayList(3);
        }
        this.fileSpecs.add(ContentType.createFileSpec(fileSpec, typeMask));
        return true;
    }

    private String internalGetDefaultCharset() {
        if (this.defaultCharset == null) {
            ContentType baseType = (ContentType)this.getBaseType();
            return baseType == null ? null : baseType.getDefaultCharset();
        }
        return this.defaultCharset;
    }

    IContentDescription internalGetDescriptionFor(InputStream buffer, QualifiedName[] options) throws IOException {
        if (this.aliasTarget != null) {
            return this.getTarget().internalGetDescriptionFor(buffer, options);
        }
        if (buffer == null) {
            return this.defaultDescription;
        }
        IContentDescriber describer = this.getDescriber();
        if (describer == null) {
            return this.defaultDescription;
        }
        ContentDescription description = new ContentDescription(options);
        this.describe(describer, buffer, description);
        if (!description.isSet()) {
            return this.defaultDescription;
        }
        if (description.isRequested(IContentDescription.CHARSET) && description.getProperty(IContentDescription.CHARSET) == null) {
            description.setProperty(IContentDescription.CHARSET, this.getDefaultCharset());
        }
        description.setContentType(this);
        return description;
    }

    IContentDescription internalGetDescriptionFor(Reader buffer, QualifiedName[] options) throws IOException {
        if (this.aliasTarget != null) {
            return this.getTarget().internalGetDescriptionFor(buffer, options);
        }
        if (buffer == null) {
            return this.defaultDescription;
        }
        IContentDescriber describer = this.getDescriber();
        if (describer == null) {
            return this.defaultDescription;
        }
        ContentDescription description = new ContentDescription(options);
        if (!(describer instanceof ITextContentDescriber)) {
            throw new UnsupportedOperationException();
        }
        this.describe((ITextContentDescriber)describer, buffer, description);
        if (!description.isSet()) {
            return this.defaultDescription;
        }
        if (description.isRequested(IContentDescription.CHARSET) && description.getProperty(IContentDescription.CHARSET) == null) {
            description.setProperty(IContentDescription.CHARSET, this.getDefaultCharset());
        }
        description.setContentType(this);
        return description;
    }

    public byte internalIsAssociatedWith(String fileName) {
        IContentType baseType;
        if (this.aliasTarget != null) {
            return this.getTarget().internalIsAssociatedWith(fileName);
        }
        if (this.hasFileSpec(fileName, 4)) {
            return 1;
        }
        String fileExtension = ContentTypeManager.getFileExtension(fileName);
        if (this.hasFileSpec(fileExtension, 8)) {
            return 2;
        }
        if (!this.hasAnyFileSpec(1) && (baseType = this.getBaseType()) != null) {
            return ((ContentType)baseType).internalIsAssociatedWith(fileName);
        }
        return 0;
    }

    private boolean hasAnyFileSpec(int typeMask) {
        if (this.fileSpecs == null || this.fileSpecs.isEmpty()) {
            return false;
        }
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if ((spec.getType() & typeMask) != typeMask) continue;
            return true;
        }
        return false;
    }

    void internalRemoveFileSpec(String fileSpec, int typeMask) {
        if (this.aliasTarget != null) {
            this.aliasTarget.internalRemoveFileSpec(fileSpec, typeMask);
            return;
        }
        if (this.fileSpecs == null) {
            return;
        }
        Iterator i = this.fileSpecs.iterator();
        while (i.hasNext()) {
            FileSpec spec = (FileSpec)i.next();
            if (spec.getType() != typeMask || !fileSpec.equals(spec.getText())) continue;
            i.remove();
            return;
        }
    }

    private IContentDescriber invalidateDescriber(Throwable reason) {
        this.setValidation((byte)2);
        String message = Policy.bind("content.invalidContentDescriber", this.getId());
        ContentType.log(message, reason);
        this.describer = new InvalidDescriber();
        return this.describer;
    }

    public boolean isAssociatedWith(String fileName) {
        return this.internalIsAssociatedWith(fileName) != 0;
    }

    public boolean isKindOf(IContentType another) {
        if (another == null) {
            return false;
        }
        if (this.aliasTarget != null) {
            return this.getTarget().isKindOf(another);
        }
        if (this == another) {
            return true;
        }
        if (this.getDepth() <= ((ContentType)another).getDepth()) {
            return false;
        }
        IContentType baseType = this.getBaseType();
        return baseType != null && baseType.isKindOf(another);
    }

    public boolean isText() {
        return this.isKindOf(this.manager.getContentType("org.eclipse.core.runtime.text"));
    }

    boolean isValid() {
        return this.validation == 1;
    }

    public static void log(String message, Throwable reason) {
        Status status = new Status(4, "org.eclipse.core.runtime", 0, message, reason instanceof CoreException ? null : reason);
        InternalPlatform.getDefault().log(status);
    }

    public synchronized void removeFileSpec(String fileSpec, int type) throws CoreException {
        Assert.isLegal(type == 8 || type == 4, "Unknown type: " + type);
        if (this.aliasTarget != null) {
            this.getTarget().removeFileSpec(fileSpec, type);
            return;
        }
        this.internalRemoveFileSpec(fileSpec, type | 2);
        String key = ContentType.getPreferenceKey(type);
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        Object[] userSet = this.internalGetFileSpecs(type | 1);
        if (userSet.length == 0) {
            contentTypeNode.remove(key);
        } else {
            contentTypeNode.put(key, ContentType.toListString(userSet));
        }
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = Policy.bind("content.errorSavingSettings", this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
    }

    void setAliasTarget(ContentType newTarget) {
        if (this.aliasTarget != null && newTarget != null) {
            return;
        }
        if (this.aliasTarget == null && this.isKindOf(newTarget)) {
            return;
        }
        if (ContentTypeManager.DEBUGGING) {
            Policy.debug("Setting alias target for " + this + " -> " + newTarget);
        }
        this.aliasTarget = newTarget;
    }

    public void setDefaultCharset(String userCharset) throws CoreException {
        this.userCharset = userCharset;
        Preferences contentTypeNode = this.manager.getPreferences().node(this.getId());
        if (userCharset == null) {
            contentTypeNode.remove(PREF_DEFAULT_CHARSET);
        } else {
            contentTypeNode.put(PREF_DEFAULT_CHARSET, userCharset);
        }
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = Policy.bind("content.errorSavingSettings", this.getId());
            Status status = new Status(4, "org.eclipse.core.runtime", 0, message, bse);
            throw new CoreException(status);
        }
    }

    void setValidation(byte validation) {
        this.validation = validation;
        if (ContentTypeManager.DEBUGGING) {
            Policy.debug("Validating " + this + ": " + ContentType.getValidationString(validation));
        }
    }

    private static String getValidationString(byte validation) {
        return validation == 1 ? "VALID" : (validation == 2 ? "INVALID" : "UNKNOWN");
    }

    public String toString() {
        return this.getId();
    }

    public boolean isAlias() {
        return this.aliasTarget != null;
    }

    private class InvalidDescriber
    implements IContentDescriber,
    ITextContentDescriber {
        InvalidDescriber() {
        }

        public int describe(InputStream contents, IContentDescription description) throws IOException {
            return 0;
        }

        public int describe(Reader contents, IContentDescription description) throws IOException {
            return 0;
        }

        public QualifiedName[] getSupportedOptions() {
            return new QualifiedName[0];
        }
    }
}

