/*
 * Decompiled with CFR 0.152.
 */
package kenya.builtIns.builtInMethods;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kenya.builtIns.BuiltInMethod;
import kenya.builtIns.IBuiltInMethodFactory;
import kenya.builtIns.IGetMethodCode;
import kenya.builtIns.SMLibraryContainer;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KType;
import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.StringTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class CharsToString
implements IBuiltInMethodFactory {
    private static final Set emptySet = Collections.unmodifiableSet(new HashSet());
    private static final String name = "charsToString";
    private static final KType returnChar = KBasicType.getString();
    private static final List paramInt = new LinkedList();
    private static final IGetMethodCode javaCode;
    private static final AbstractAtomicClosure execute;

    public String getName() {
        return name;
    }

    public Set buildMethods() {
        HashSet<BuiltInMethod> methods = new HashSet<BuiltInMethod>();
        SMLibraryContainer smLibrary = SMLibraryContainer.getLibrary();
        InterpretedMethod method = new InterpretedMethod(this.getName(), smLibrary.getLibraryClass(), true, true);
        method.setMethodBody(execute);
        smLibrary.addStaticMethod(method);
        BuiltInMethod bim = new BuiltInMethod();
        bim.setCodeHook(javaCode);
        bim.setImports(emptySet);
        bim.setName(this.getName());
        bim.setMethodParameters(paramInt);
        bim.hasReturnType(returnChar);
        bim.setReservedClasses(emptySet);
        bim.setInterpretedMethod(method);
        methods.add(bim);
        return methods;
    }

    public String toString() {
        return this.getName();
    }

    static {
        paramInt.add(new KArrayType(KBasicType.getChar()));
        javaCode = new IGetMethodCode(){

            public String[] getCode(List parameterValues, List parameterTypes) {
                if (parameterValues.size() != parameterTypes.size()) {
                    throw new RuntimeException("I was expecting " + parameterTypes.size() + " parameters and received " + parameterValues.size() + " parameters");
                }
                String[] lhs = new String[]{"new", " ", "String("};
                String[] middle = (String[])parameterValues.get(0);
                String[] rhs = new String[]{")"};
                return BuiltInMethod.concatenate(lhs, middle, rhs);
            }
        };
        execute = new AbstractAtomicClosure(){

            public void execute(StackMachine sm) {
                IArrayType arg = (IArrayType)sm.pop();
                IType[] charTypes = arg.getValue();
                char[] chars = new char[charTypes.length];
                for (int idx = 0; idx < charTypes.length; ++idx) {
                    chars[idx] = ((ICharType)charTypes[idx]).getValue().charValue();
                }
                String stringResult = new String(chars);
                sm.push(StringTypeFactory.createStringType(stringResult));
            }

            public String toString() {
                return CharsToString.name;
            }
        };
    }
}

