/*
 * Decompiled with CFR 0.152.
 */
package kenya.interpreter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;
import org.wellquite.kenya.stackMachine.types.interfaces.INonPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class InterpreterInspectorContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Map parentMap = new HashMap();

    public synchronized Object[] getChildren(Object parentElement) {
        IInterpretedClass classStatic;
        if (parentElement == null) {
            return null;
        }
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof IMethodScope) {
            IInterpretedClassInstance classInstance;
            IMethodScope currentMethod = (IMethodScope)parentElement;
            classStatic = currentMethod.getCurrentClass();
            if (classStatic != null) {
                children.addAll(classStatic.getImmutableStaticVariables().entrySet());
                children.addAll(classStatic.getMutableStaticVariables().entrySet());
            }
            if (!currentMethod.isStatic() && (classInstance = currentMethod.getCurrentClassInstance()) != null) {
                children.addAll(classInstance.getImmutableInstanceVariables().entrySet());
                children.addAll(classInstance.getMutableInstanceVariables().entrySet());
            }
            children.addAll(currentMethod.getLocalImmutableVariables().entrySet());
            children.addAll(currentMethod.getLocalMutableVariables().entrySet());
        } else if (parentElement instanceof Map.Entry) {
            IType value = (IType)((Map.Entry)parentElement).getValue();
            if (value instanceof IArrayType) {
                IType[] array = ((IArrayType)value).getValue();
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                HashMap<String, IType> valueMap = new HashMap<String, IType>();
                for (int idx = 0; idx < array.length; ++idx) {
                    String index = "[" + idx + "]";
                    indexMap.put(index, new Integer(idx));
                    valueMap.put(index, array[idx]);
                    children.add(idx, array[idx]);
                }
                for (Map.Entry entry : valueMap.entrySet()) {
                    int position = (Integer)indexMap.get(entry.getKey());
                    children.set(position, entry);
                }
                indexMap.clear();
                valueMap.clear();
            } else if (value instanceof IClassInstanceType) {
                IInterpretedClassInstance classInstance = ((IClassInstanceType)value).getValue();
                children.addAll(classInstance.getInterpretedClass().getImmutableStaticVariables().entrySet());
                children.addAll(classInstance.getInterpretedClass().getMutableStaticVariables().entrySet());
                children.addAll(classInstance.getImmutableInstanceVariables().entrySet());
                children.addAll(classInstance.getMutableInstanceVariables().entrySet());
            } else if (value instanceof IClassStaticType) {
                classStatic = ((IClassStaticType)value).getValue();
                children.addAll(classStatic.getImmutableStaticVariables().entrySet());
                children.addAll(classStatic.getMutableStaticVariables().entrySet());
            } else {
                System.err.println("Unknown Map.Entry type for getChildren: " + parentElement);
            }
        } else {
            System.err.println("Unknown type for getChildren: " + parentElement);
        }
        Object[] childrenArray = children.toArray();
        for (int idx = 0; idx < childrenArray.length; ++idx) {
            this.parentMap.put(childrenArray[idx], parentElement);
        }
        return childrenArray;
    }

    public synchronized Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        return this.parentMap.get(element);
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            if (entry.getValue() instanceof IPrimitiveType) {
                if (entry.getValue() instanceof IArrayType) {
                    return ((IArrayType)entry.getValue()).getLength() != 0;
                }
                return false;
            }
            if (entry.getValue() instanceof INullType) {
                return false;
            }
            if (entry.getValue() instanceof IGenericType) {
                return false;
            }
            if (entry.getValue() instanceof INonPrimitiveType) {
                if (entry.getValue() instanceof IEnumType) {
                    return false;
                }
                return !(entry.getValue() instanceof IStringType);
            }
            System.err.println("Unknown entry type: " + element.toString());
            return false;
        }
        if (element instanceof IMethodScope) {
            return true;
        }
        System.err.println("Unknown type: " + element.toString());
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof StackMachine) {
            return this.getChildren(((StackMachine)inputElement).getMethodScope());
        }
        if (inputElement instanceof IMethodScope) {
            return this.getChildren(inputElement);
        }
        return EMPTY_ARRAY;
    }

    public synchronized void dispose() {
        this.parentMap.clear();
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.parentMap.clear();
    }
}

